/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;

public class CutSugarCaneBlock
extends SugarCaneBlock {
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public CutSugarCaneBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState soil = pLevel.getBlockState(pPos.below());
        if (soil.canSustainPlant((BlockGetter)pLevel, pPos.below(), Direction.UP, this.defaultBlockState()) == TriState.TRUE) {
            return true;
        }
        BlockState blockstate = pLevel.getBlockState(pPos.below());
        if (blockstate.is(Blocks.SUGAR_CANE)) {
            return true;
        }
        if (blockstate.is(BlockTags.DIRT) || blockstate.is(BlockTags.SAND)) {
            BlockPos blockpos = pPos.below();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate1 = pLevel.getBlockState(blockpos.relative(direction));
                FluidState fluidstate = pLevel.getFluidState(blockpos.relative(direction));
                if (!pState.canBeHydrated((BlockGetter)pLevel, pPos, fluidstate, blockpos.relative(direction)) && !blockstate1.is(Blocks.FROSTED_ICE)) continue;
                return true;
            }
        }
        return false;
    }
}

