/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.farcr.nomansland.common.registry.NMLDamageTypes;
import com.farcr.nomansland.common.registry.NMLTags;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class IciclesBlock
extends Block
implements Fallable {
    public static final MapCodec<IciclesBlock> CODEC = IciclesBlock.simpleCodec(IciclesBlock::new);
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;

    public IciclesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TIP_DIRECTION, (Comparable)Direction.DOWN));
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP) {
            entity.causeFallDamage(fallDistance + 2.0f, 1.0f, NMLDamageTypes.getSimpleDamageSource(level, NMLDamageTypes.ICICLE_PIERCE));
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.setTicksFrozen(40);
            }
            level.destroyBlock(pos, false);
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction placementDirection = context.getNearestLookingVerticalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)placementDirection);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TIP_DIRECTION});
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        boolean aboveSupportsIcicle = level.getBlockState(pos.above()).is(NMLTags.SUPPORTS_ICICLE) && state.getValue((Property)TIP_DIRECTION) == Direction.DOWN;
        boolean belowSupportsIcicle = level.getBlockState(pos.below()).is(NMLTags.SUPPORTS_ICICLE) && state.getValue((Property)TIP_DIRECTION) == Direction.UP;
        return aboveSupportsIcicle || belowSupportsIcicle;
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.getValue((Property)TIP_DIRECTION) == Direction.UP) {
            return Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)14.0);
        }
        return Block.box((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)14.0);
    }

    public DamageSource getFallDamageSource(Entity entity) {
        return NMLDamageTypes.getSimpleDamageSource(entity.level(), NMLDamageTypes.ICICLE_PIERCE);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP) {
            level.destroyBlock(pos, false);
        } else if (!this.canSurvive(state, (LevelReader)level, pos)) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state);
            fallingBlockEntity.setHurtsEntities(2.0f, 40);
            fallingBlockEntity.disableDrop();
        }
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction p_direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 2);
        }
        super.updateShape(state, p_direction, neighborState, level, pos, neighborPos);
        return state;
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        if (!fallingBlock.isSilent() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.playSound((Entity)fallingBlock, pos, SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!level.isClientSide() && Direction.getNearest((Vec3)livingEntity.getDeltaMovement()) == Direction.UP && state.getValue((Property)TIP_DIRECTION) == Direction.DOWN) {
                level.destroyBlock(pos, false);
                livingEntity.setTicksFrozen(40);
                livingEntity.hurt(NMLDamageTypes.getSimpleDamageSource(level, NMLDamageTypes.ICICLE_PIERCE), 4.0f);
            }
        }
    }
}

