/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.farcr.nomansland.common.blockentity.anchor.MonsterAnchorBlockEntity;
import com.farcr.nomansland.common.registry.NMLBlockEntities;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MonsterAnchorBlock
extends BaseEntityBlock {
    public static final MapCodec<MonsterAnchorBlock> CODEC = MonsterAnchorBlock.simpleCodec(MonsterAnchorBlock::new);
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public MonsterAnchorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{ACTIVE}));
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)ACTIVE) != false ? 4 : 0;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return (Boolean)state.getValue((Property)ACTIVE);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        MonsterAnchorBlockEntity anchor = (MonsterAnchorBlockEntity)level.getBlockEntity(pos);
        if (anchor.entityQueue.size() >= 20) {
            return 15;
        }
        if (anchor.entityQueue.size() == 1) {
            return 1;
        }
        return 15 / (anchor.entityQueue.size() - 1) * anchor.entityQueue.size();
    }

    public int getExpDrop(BlockState state, LevelAccessor level, BlockPos pos, BlockEntity blockEntity, Entity breaker, ItemStack tool) {
        return 20 + level.getRandom().nextInt(20) + level.getRandom().nextInt(20);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MonsterAnchorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : MonsterAnchorBlock.createTickerHelper(blockEntityType, NMLBlockEntities.MONSTER_ANCHOR.get(), MonsterAnchorBlockEntity::tick);
    }
}

