/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class WoodenScaffoldingBlock
extends ScaffoldingBlock {
    public WoodenScaffoldingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(6))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    public static int getDistance(BlockGetter level, BlockPos pos) {
        Direction direction;
        BlockState blockstate1;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable().move(Direction.DOWN);
        BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
        int i = 6;
        if (blockstate.is(NMLBlocks.WOODEN_SCAFFOLDING.block())) {
            i = (Integer)blockstate.getValue((Property)DISTANCE);
        } else if (blockstate.isFaceSturdy(level, (BlockPos)blockpos$mutableblockpos, Direction.UP)) {
            return 0;
        }
        Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
        while (iterator.hasNext() && (!(blockstate1 = level.getBlockState((BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction = (Direction)iterator.next()))).is(NMLBlocks.WOODEN_SCAFFOLDING.block()) || (i = Math.min(i, (Integer)blockstate1.getValue((Property)DISTANCE) + 1)) != 1)) {
        }
        return i;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos $$1 = context.getClickedPos();
        Level $$2 = context.getLevel();
        int $$3 = WoodenScaffoldingBlock.getDistance((BlockGetter)$$2, $$1);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf($$2.getFluidState($$1).getType() == Fluids.WATER))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf($$3))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((BlockGetter)$$2, $$1, $$3)));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = WoodenScaffoldingBlock.getDistance((BlockGetter)level, pos);
        BlockState blockstate = (BlockState)((BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((BlockGetter)level, pos, i)));
        if (((Integer)blockstate.getValue((Property)DISTANCE)).equals(6)) {
            if (((Integer)state.getValue((Property)DISTANCE)).equals(6)) {
                FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)blockstate);
            } else {
                level.destroyBlock(pos, true);
            }
        } else if (state != blockstate) {
            level.setBlock(pos, blockstate, 3);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return WoodenScaffoldingBlock.getDistance((BlockGetter)level, pos) < 6;
    }

    private boolean isBottom(BlockGetter level, BlockPos pos, int distance) {
        return distance > 0 && !level.getBlockState(pos.below()).is((Block)this);
    }

    public boolean isScaffolding(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }
}

