/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block.cauldrons;

import com.farcr.nomansland.common.block.cauldrons.FourLayeredCauldronBlock;
import com.farcr.nomansland.common.registry.NMLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class HoneyCauldron
extends FourLayeredCauldronBlock {
    public HoneyCauldron() {
        super(() -> ParticleTypes.FALLING_HONEY);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean interacted = false;
        ItemStack containedStack = new ItemStack((ItemLike)Items.HONEY_BLOCK);
        if (this.isFull(state)) {
            if (!player.getInventory().add(containedStack)) {
                player.drop(containedStack, false);
            }
            interacted = true;
            BlockState newState = Blocks.CAULDRON.defaultBlockState();
            level.setBlockAndUpdate(pos, newState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
        }
        if (interacted) {
            player.awardStat(Stats.USE_CAULDRON);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean interacted = false;
        ItemStack bottleStack = new ItemStack((ItemLike)Items.HONEY_BOTTLE);
        if (stack.is(Items.GLASS_BOTTLE)) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)bottleStack));
            interacted = true;
            HoneyCauldron.lowerFillLevel(state, level, pos);
            level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
        }
        if (stack.is(bottleStack.getItem()) && !this.isFull(state)) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.GLASS_BOTTLE.getDefaultInstance()));
            interacted = true;
            this.raiseFillLevel(state, level, pos);
            level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
        }
        if (interacted) {
            player.awardStat(Stats.USE_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (this.isEntityInsideContent(state, pos, entity)) {
            if (entity instanceof LivingEntity && (Integer)state.getValue((Property)LEVEL) > 1) {
                level.playSound(null, pos, (SoundEvent)NMLSounds.STICKY_CAULDRON_SLIDE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                entity.makeStuckInBlock(state, new Vec3(0.9, 0.9, 0.9));
            }
            if (!level.isClientSide && entity.isOnFire()) {
                entity.clearFire();
                level.playSound(entity, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

