/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block.cauldrons;

import com.farcr.nomansland.common.block.cauldrons.FourLayeredCauldronBlock;
import com.farcr.nomansland.common.registry.NMLParticleTypes;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.entities.NMLEffects;
import com.farcr.nomansland.common.registry.items.NMLItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ResinOilCauldron
extends FourLayeredCauldronBlock {
    public ResinOilCauldron() {
        super(NMLParticleTypes.OIL);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.getBlockState(pos.below()).is(NMLTags.HEAT_SOURCES)) {
            double d0 = (double)pos.getX() + 0.5 + (double)random.nextInt(-40, 40) * 0.01;
            double d1 = (double)pos.getY() + (double)random.nextInt(-10, 40) * 0.001 + this.getContentHeight(state);
            double d2 = (double)pos.getZ() + 0.5 + (double)random.nextInt(-40, 40) * 0.01;
            level.addParticle((ParticleOptions)NMLParticleTypes.RESIN_OIL_BUBBLE.get(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean interacted = false;
        ItemStack bottleStack = new ItemStack((ItemLike)NMLItems.RESIN_OIL_BOTTLE.get());
        if (stack.is(Items.GLASS_BOTTLE)) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)bottleStack));
            interacted = true;
            ResinOilCauldron.lowerFillLevel(state, level, pos);
            level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
        }
        if (stack.is(bottleStack.getItem()) && !this.isFull(state)) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)Items.GLASS_BOTTLE.getDefaultInstance()));
            interacted = true;
            this.raiseFillLevel(state, level, pos);
            level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
        }
        if (interacted) {
            player.awardStat(Stats.USE_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (this.isEntityInsideContent(state, pos, entity) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(NMLEffects.FLAMMABLE, 100));
                if (entity.isOnFire() && this.isEntityInsideContent(state, pos, entity) && entity.getY() < (double)pos.getY() + 0.6) {
                    entity.setRemainingFireTicks(entity.getRemainingFireTicks() + 50 * (Integer)state.getValue((Property)LEVEL));
                    level.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
                    for (int i = 0; i <= (Integer)state.getValue((Property)LEVEL) * 25; ++i) {
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, entity.getX() + (double)level.random.nextInt(-10, 10) * 0.005, entity.getY() + 0.7 + (double)level.random.nextInt(-10, 10) * 0.05 - (double)i * 0.2, entity.getZ() + (double)level.random.nextInt(-10, 10) * 0.01, (Integer)state.getValue((Property)LEVEL) * 2, (double)level.random.nextInt(-10, 10) * 0.005, (double)((Integer)state.getValue((Property)LEVEL)).intValue() * 0.2, (double)level.random.nextInt(-10, 10) * 0.005, 0.05);
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMALL_FLAME, entity.getX() + (double)level.random.nextInt(-10, 10) * 0.005, entity.getY() + 0.7 + (double)level.random.nextInt(-10, 10) * 0.05 - (double)i * 0.2, entity.getZ() + (double)level.random.nextInt(-10, 10) * 0.01, (Integer)state.getValue((Property)LEVEL) * 2, (double)level.random.nextInt(-10, 10) * 0.005, (double)((Integer)state.getValue((Property)LEVEL)).intValue() * 0.2, (double)level.random.nextInt(-10, 10) * 0.005, 0.05);
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, entity.getX() + (double)level.random.nextInt(-10, 10) * 0.005, entity.getY() + 0.7 + (double)level.random.nextInt(-10, 10) * 0.05 - (double)i * 0.2, entity.getZ() + (double)level.random.nextInt(-10, 10) * 0.01, (Integer)state.getValue((Property)LEVEL) * 2, (double)level.random.nextInt(-10, 10) * 0.005, (double)((Integer)state.getValue((Property)LEVEL)).intValue() * 0.2, (double)level.random.nextInt(-10, 10) * 0.005, 0.05);
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, entity.getX() + (double)level.random.nextInt(-10, 10) * 0.005, entity.getY() + 0.7 + (double)level.random.nextInt(-10, 10) * 0.05 - (double)i * 0.2, entity.getZ() + (double)level.random.nextInt(-10, 10) * 0.01, (Integer)state.getValue((Property)LEVEL) * 2, (double)level.random.nextInt(-10, 10) * 0.005, (double)((Integer)state.getValue((Property)LEVEL)).intValue() * 0.2, (double)level.random.nextInt(-10, 10) * 0.005, 0.05);
                    }
                    entity.hurt(entity.damageSources().inFire(), (float)((Integer)state.getValue((Property)LEVEL) * 3));
                    serverLevel.playLocalSound(pos, SoundEvents.GENERIC_BURN, SoundSource.BLOCKS, (float)((Integer)state.getValue((Property)LEVEL)).intValue() * 0.5f, 0.5f, false);
                    serverLevel.playLocalSound(pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, (float)((Integer)state.getValue((Property)LEVEL)).intValue() * 0.5f, 0.5f, false);
                }
            }
        }
    }
}

