/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block.torches;

import com.farcr.nomansland.common.block.torches.ExtinguishedSconceWallTorchBlock;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SconceWallTorchBlock
extends WallTorchBlock {
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)5.5, (double)1.5, (double)11.0, (double)10.5, (double)13.5, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)5.5, (double)1.5, (double)0.0, (double)10.5, (double)13.5, (double)5.0), (Object)Direction.WEST, (Object)Block.box((double)11.0, (double)1.5, (double)5.5, (double)16.0, (double)13.5, (double)10.5), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)1.5, (double)5.5, (double)5.0, (double)13.5, (double)10.5)));

    public SconceWallTorchBlock(SimpleParticleType flameParticle, BlockBehaviour.Properties properties) {
        super(flameParticle, properties);
    }

    public static VoxelShape getShape(BlockState state) {
        return AABBS.get(state.getValue((Property)FACING));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SconceWallTorchBlock.getShape(state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
        double dx = (double)pos.getX() + 0.5;
        double dy = (double)pos.getY() + 0.7;
        double dz = (double)pos.getZ() + 0.5;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, dx + 0.2 * (double)direction.getStepX(), dy + 0.22, dz + 0.2 * (double)direction.getStepZ(), 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)this.flameParticle, dx + 0.2 * (double)direction.getStepX(), dy + 0.22, dz + 0.2 * (double)direction.getStepZ(), 0.0, 0.0, 0.0);
    }

    protected void onExplosionHit(BlockState state, Level level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        if (explosion.canTriggerBlocks()) {
            level.setBlockAndUpdate(pos, state.is(NMLBlocks.SCONCE_SOUL_WALL_TORCH.block()) ? ((ExtinguishedSconceWallTorchBlock)((Object)NMLBlocks.EXTINGUISHED_SCONCE_SOUL_WALL_TORCH.get())).withPropertiesOf(state) : ((ExtinguishedSconceWallTorchBlock)((Object)NMLBlocks.EXTINGUISHED_SCONCE_WALL_TORCH.get())).withPropertiesOf(state));
        }
        super.onExplosionHit(state, level, pos, explosion, dropConsumer);
    }
}

