/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.blockentity.anchor;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.block.MonsterAnchorBlock;
import com.farcr.nomansland.common.blockentity.anchor.AnchorListener;
import com.farcr.nomansland.common.registry.NMLBlockEntities;
import com.farcr.nomansland.common.registry.NMLParticleTypes;
import com.farcr.nomansland.common.registry.NMLSounds;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class MonsterAnchorBlockEntity
extends BlockEntity
implements GameEventListener.Provider<AnchorListener> {
    public final ArrayList<CompoundTag> entityQueue;
    private final AnchorListener anchorListener;
    public int timeResurrecting;
    public int timeIdle;
    public int range;

    public MonsterAnchorBlockEntity(BlockPos pos, BlockState state) {
        super(NMLBlockEntities.MONSTER_ANCHOR.get(), pos, state);
        this.anchorListener = new AnchorListener(state, (PositionSource)new BlockPositionSource(pos));
        this.entityQueue = new ArrayList();
        this.timeResurrecting = 0;
        this.timeIdle = 0;
        this.range = 7;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MonsterAnchorBlockEntity monsterAnchor) {
        ServerLevel serverLevel = (ServerLevel)level;
        ArrayList<CompoundTag> entityQueue = monsterAnchor.entityQueue;
        boolean empty = entityQueue.isEmpty();
        RandomSource random = level.random;
        int timeBetweenResurrections = (Integer)NMLConfig.TICKS_BETWEEN_RESURRECTIONS.get();
        if (empty) {
            monsterAnchor.timeResurrecting = 0;
            ++monsterAnchor.timeIdle;
            if (((Boolean)state.getValue((Property)MonsterAnchorBlock.ACTIVE)).booleanValue()) {
                level.playSound(null, pos, (SoundEvent)NMLSounds.MONSTER_ANCHOR_DEACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 0.75f);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)MonsterAnchorBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
                level.gameEvent((Holder)GameEvent.BLOCK_DEACTIVATE, pos, GameEvent.Context.of((BlockState)state));
            } else if (monsterAnchor.timeIdle % 5 == 0) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + (double)random.nextInt(0, 3) * 0.01 - (double)random.nextInt(0, 3) * 0.01, (double)pos.getY() + 0.2, (double)pos.getZ() + 0.5 + (double)random.nextInt(0, 3) * 0.01 - (double)random.nextInt(0, 3) * 0.01, 3, 0.0, 0.0, 0.0, 0.0);
                monsterAnchor.timeIdle = 0;
            }
            return;
        }
        monsterAnchor.timeIdle = 0;
        ++monsterAnchor.timeResurrecting;
        serverLevel.sendParticles((ParticleOptions)NMLParticleTypes.MALEVOLENT_FLAME.get(), (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), monsterAnchor.timeResurrecting, 0.0, 0.0, 0.0, 0.0);
        for (int i = 0; i < entityQueue.size(); ++i) {
            CompoundTag deadEntity = entityQueue.get(i);
            Entity loadedEntity = EntityType.loadEntityRecursive((CompoundTag)deadEntity, (Level)level, e -> e);
            if (!(loadedEntity instanceof LivingEntity)) continue;
            LivingEntity resurrectedEntity = (LivingEntity)loadedEntity;
            Vec3 spawningPosition = resurrectedEntity.position();
            if (!resurrectedEntity.isSupportedBy(BlockPos.containing((Position)spawningPosition).below())) {
                for (int y = 1; y < 5; ++y) {
                    if (!level.getBlockState(BlockPos.containing((Position)spawningPosition).below(y)).isSolid()) continue;
                    spawningPosition = spawningPosition.subtract(0.0, (double)(y - 1), 0.0);
                    resurrectedEntity.moveTo(spawningPosition);
                    break;
                }
            }
            if (level.random.nextFloat() <= 0.1f) {
                serverLevel.sendParticles((ParticleOptions)NMLParticleTypes.MALEVOLENT_FLAME.get(), spawningPosition.x + (double)random.nextFloat() - (double)random.nextFloat(), spawningPosition.y + (double)random.nextFloat() - (double)random.nextFloat(), spawningPosition.z + (double)random.nextFloat() - (double)random.nextFloat(), 3, 0.0, 0.0, 0.0, 0.0);
            }
            if (monsterAnchor.timeResurrecting % timeBetweenResurrections == 0 && i != 0) {
                double y = spawningPosition.y + 0.1;
                AnchorListener.surroundBoundingBox(resurrectedEntity.getBoundingBox(), 0.2).forEach(point -> serverLevel.sendParticles((ParticleOptions)NMLParticleTypes.MALEVOLENT_EMBERS.get(), point.x, y, point.z, 1, 0.0, 0.0, 0.0, 0.0));
            }
            if (i == 0) {
                if (monsterAnchor.timeResurrecting == timeBetweenResurrections - 78) {
                    double y = spawningPosition.y + 0.1;
                    AnchorListener.surroundBoundingBox(resurrectedEntity.getBoundingBox(), 0.2).forEach(point -> serverLevel.sendParticles((ParticleOptions)NMLParticleTypes.MALEVOLENT_EMBERS.get(), point.x, y, point.z, 1, 0.0, 0.0, 0.0, 0.0));
                    if (!((Boolean)state.getValue((Property)MonsterAnchorBlock.ACTIVE)).booleanValue()) {
                        level.playSound(null, pos, (SoundEvent)NMLSounds.MONSTER_ANCHOR_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)MonsterAnchorBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
                        level.gameEvent((Holder)GameEvent.BLOCK_ACTIVATE, pos, GameEvent.Context.of((BlockState)state));
                    }
                    level.playSound(null, pos, (SoundEvent)NMLSounds.MONSTER_ANCHOR_RESURRECTION.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (monsterAnchor.timeResurrecting != timeBetweenResurrections) continue;
                monsterAnchor.timeResurrecting = 0;
                resurrectedEntity.setHealth(resurrectedEntity.getMaxHealth());
                resurrectedEntity.setDeltaMovement(Vec3.ZERO);
                level.addFreshEntity((Entity)resurrectedEntity);
                resurrectedEntity.playSound((SoundEvent)NMLSounds.MONSTER_ANCHOR_SPAWN.get(), 1.0f, 1.0f);
                double y = spawningPosition.y + 0.5;
                AnchorListener.surroundBoundingBox(resurrectedEntity.getBoundingBox(), 0.4).forEach(point -> serverLevel.sendParticles((ParticleOptions)NMLParticleTypes.MALEVOLENT_FLAME.get(), point.x, y, point.z, 1, 0.0, 0.0, 0.0, 0.1));
                continue;
            }
            resurrectedEntity.remove(Entity.RemovalReason.DISCARDED);
        }
        if (monsterAnchor.timeResurrecting % timeBetweenResurrections == 0) {
            entityQueue.removeFirst();
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("TimeIdle", this.timeIdle);
        tag.putInt("TimeResurrecting", this.timeResurrecting);
        tag.putInt("Range", this.range);
        this.entityQueue.forEach(entityTag -> tag.put("Entity" + this.entityQueue.indexOf(entityTag), (Tag)entityTag));
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.timeIdle = tag.getInt("TimeIdle");
        this.timeResurrecting = tag.getInt("TimeResurrecting");
        this.range = Math.min(tag.getInt("Range"), 16);
        int i = 0;
        Tag foundTag = tag.get("Entity0");
        while (foundTag instanceof CompoundTag) {
            CompoundTag entityTag = (CompoundTag)foundTag;
            this.entityQueue.add(entityTag);
            foundTag = tag.get("Entity" + ++i);
        }
        super.loadAdditional(tag, registries);
    }

    public AnchorListener getListener() {
        return this.anchorListener;
    }
}

