/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.effect;

import com.farcr.nomansland.common.entity.ai.EnemyAttackGoal;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.entities.NMLEffects;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Monster;

public class PacifiedEffect
extends MobEffect {
    public PacifiedEffect(MobEffectCategory category) {
        super(category, 1);
        this.particleFactory = i -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)13041538));
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide && livingEntity.tickCount % 5 == 0) {
            RandomSource random = livingEntity.getRandom();
            ColorParticleOption particle = switch (livingEntity.level().getRandom().nextInt(6)) {
                case 0 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)13041538));
                case 1 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)16768386));
                case 2 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)16692156));
                case 3 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)16679679));
                case 4 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)14058239));
                default -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)FastColor.ARGB32.color((int)51, (int)8585152));
            };
            double x = livingEntity.getX() + (random.nextDouble() - 0.5) * (double)livingEntity.getBbWidth();
            double y = livingEntity.getY() + random.nextDouble() * (double)livingEntity.getBbHeight();
            double z = livingEntity.getZ() + (random.nextDouble() - 0.5) * (double)livingEntity.getBbWidth();
            ((ServerLevel)livingEntity.level()).sendParticles((ParticleOptions)particle, x, y, z, 0, 0.0, 0.0, 0.0, 0.0);
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public void onEffectAdded(LivingEntity livingEntity, int amplifier) {
        super.onEffectAdded(livingEntity, amplifier);
        if (livingEntity.getType().getTags().toList().contains(NMLTags.CANNOT_BE_PACIFIED)) {
            livingEntity.removeEffect(NMLEffects.PACIFIED);
            return;
        }
        if (livingEntity instanceof NeutralMob) {
            NeutralMob neutralMob = (NeutralMob)livingEntity;
            neutralMob.stopBeingAngry();
            livingEntity.removeEffect(NMLEffects.PACIFIED);
        } else if (livingEntity instanceof Monster) {
            Monster monster = (Monster)livingEntity;
            for (WrappedGoal goal : monster.targetSelector.getAvailableGoals()) {
                if (!(goal.getGoal() instanceof EnemyAttackGoal)) continue;
                return;
            }
            monster.targetSelector.addGoal(0, (Goal)new EnemyAttackGoal((Mob)monster));
        } else {
            livingEntity.removeEffect(NMLEffects.PACIFIED);
        }
    }
}

