/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity;

import com.farcr.nomansland.common.entity.Ember;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.farcr.nomansland.common.registry.items.NMLItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class IncendiaryArrow
extends AbstractArrow {
    public IncendiaryArrow(EntityType<? extends IncendiaryArrow> entityType, Level level) {
        super(entityType, level);
    }

    public IncendiaryArrow(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(NMLEntities.INCENDIARY_ARROW.get(), x, y, z, level, pickupItemStack, firedFromWeapon);
        this.setRemainingFireTicks(600);
    }

    public IncendiaryArrow(LivingEntity owner, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(NMLEntities.INCENDIARY_ARROW.get(), owner, level, pickupItemStack, firedFromWeapon);
        this.setRemainingFireTicks(600);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        entity.igniteForSeconds(30.0f);
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.isOnFire()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY() + 0.1, this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.02, -0.01, ((double)this.random.nextFloat() - 0.5) * 0.02);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Direction direction = result.getDirection();
        BlockPos pos = result.getBlockPos();
        Level level = this.level();
        BlockState state = level.getBlockState(pos);
        BlockPos neighbourPos = pos.relative(direction);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean ignitedFire = false;
            if (this.isOnFire()) {
                if (level.getBlockState(neighbourPos).is(Blocks.FIRE)) {
                    BlockPos.withinManhattan((BlockPos)neighbourPos, (int)1, (int)0, (int)1).forEach(firePos -> {
                        if ((BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)firePos, (Direction)direction) || level.getBlockState(firePos).isFlammable((BlockGetter)level, firePos, direction)) && level.random.nextFloat() < 0.4f) {
                            level.setBlockAndUpdate(firePos, BaseFireBlock.getState((BlockGetter)level, (BlockPos)firePos));
                        }
                    });
                    ignitedFire = true;
                } else if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)neighbourPos, (Direction)direction) || state.isFlammable((BlockGetter)level, pos, direction) || direction == Direction.UP) {
                    level.setBlockAndUpdate(neighbourPos, BaseFireBlock.getState((BlockGetter)level, (BlockPos)neighbourPos));
                    ignitedFire = true;
                }
            }
            if (ignitedFire) {
                level.playSound(null, this.blockPosition(), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 1.0f, 0.9f + level.random.nextFloat() * 0.2f);
                level.playSound(null, this.blockPosition(), SoundEvents.FIRE_AMBIENT, SoundSource.PLAYERS, 0.6f, 0.7f + level.random.nextFloat() * 0.3f);
                for (int i = 0; i < 10; ++i) {
                    double velX = (this.random.nextDouble() - 0.5) * 0.3;
                    double velY = 0.05 + this.random.nextDouble() * 0.15;
                    double velZ = (this.random.nextDouble() - 0.5) * 0.3;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLAME, this.position().x, this.position().y, this.position().z, 1, velX, velY, velZ, 0.1);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.position().x, this.position().y, this.position().z, 1, velX * 0.5, velY * 0.5, velZ * 0.5, 0.2);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.LAVA, this.position().x, this.position().y, this.position().z, 1, velX, 0.05, velZ, 0.3);
                }
            } else if (this.isOnFire()) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.position().x, this.position().y, this.position().z, 8, 0.0, 0.05, 0.0, 0.01);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.position().x, this.position().y, this.position().z, 4, 0.0, 0.0, 0.0, 0.01);
                level.playSound(null, this.blockPosition(), SoundEvents.FLINTANDSTEEL_USE, SoundSource.PLAYERS, 0.6f, 1.2f);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.LAVA, this.position().x, this.position().y, this.position().z, 4, 0.0, -0.05, 0.0, 0.01);
                Ember ember = new Ember(level, this.getX(), this.getY(), this.getZ());
                level.addFreshEntity((Entity)ember);
                this.clearFire();
            }
            if (this.isOnFire()) {
                this.discard();
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.position().x, this.position().y, this.position().z, 5, 0.0, 0.0, 0.0, 0.01);
            }
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return NMLItems.INCENDIARY_ARROW.stack();
    }

    protected ItemStack getPickupItem() {
        return this.isOnFire() ? this.getDefaultPickupItem() : new ItemStack((ItemLike)Items.ARROW);
    }
}

