/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity;

import com.farcr.nomansland.common.entity.LingeringCloud;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import java.util.List;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class InkCloud
extends LingeringCloud {
    public InkCloud(EntityType<? extends LingeringCloud> entityType, Level level) {
        super(entityType, level);
    }

    public InkCloud(Level level, double x, double y, double z) {
        super(NMLEntities.INK_CLOUD.get(), level);
        this.setPos(x, y, z);
        this.setNoGravity(false);
        this.noPhysics = false;
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (level.getBlockState(this.blockPosition().above((int)((double)this.getBbHeight() * 0.3))).isAir()) {
            Vec3 motion = this.getDeltaMovement();
            double dy = Mth.clamp((double)(motion.y - 0.02), (double)-0.04, (double)0.0);
            this.setDeltaMovement(motion.x, dy, motion.z);
            this.move(MoverType.SELF, this.getDeltaMovement());
        }
        if (level.isClientSide) {
            boolean isWaiting = this.isWaiting();
            float radius = this.getRadius();
            double centerY = this.getY() + (double)this.getBbHeight() / 2.0;
            if (isWaiting && this.random.nextBoolean()) {
                return;
            }
            ParticleOptions particle = this.getParticle((LevelAccessor)level);
            int count = isWaiting ? 2 : Mth.ceil((double)(Math.PI * (double)radius * (double)radius));
            float spread = isWaiting ? 0.2f : radius;
            for (int i = 0; i < count; ++i) {
                double theta = this.random.nextDouble() * 6.2831854820251465;
                double phi = Math.acos(2.0 * this.random.nextDouble() - 1.0);
                double r = (double)spread * Math.cbrt(this.random.nextDouble());
                double sinPhi = Math.sin(phi);
                double x = this.getX() + r * sinPhi * Math.cos(theta);
                double y = centerY + r * Math.cos(phi);
                double z = this.getZ() + r * sinPhi * Math.sin(theta);
                if (isWaiting) {
                    level.addAlwaysVisibleParticle(particle, x, y, z, 0.0, 0.0, 0.0);
                    continue;
                }
                level.addAlwaysVisibleParticle(particle, x, y, z, (0.5 - this.random.nextDouble()) * 0.15, 0.01, (0.5 - this.random.nextDouble()) * 0.15);
            }
        }
        if (this.tickCount % 10 == 0) {
            double centerY = this.getY() + (double)this.getBbHeight() / 2.0;
            Vec3 center = new Vec3(this.getX(), centerY, this.getZ());
            float radius = this.getRadius();
            AABB area = new AABB(this.getX() - (double)radius, centerY - (double)radius, this.getZ() - (double)radius, this.getX() + (double)radius, centerY + (double)radius, this.getZ() + (double)radius);
            List entities = level.getEntitiesOfClass(LivingEntity.class, area);
            for (LivingEntity entity : entities) {
                if (!(entity.getEyePosition().distanceToSqr(center) < (double)Mth.square((float)radius)) || !entity.isAffectedByPotions()) continue;
                boolean immune = false;
                for (ItemStack stack : entity.getArmorSlots()) {
                    if (!stack.is(NMLTags.INK_IMMUNE)) continue;
                    immune = true;
                    break;
                }
                if (!immune) {
                    entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 30));
                    entity.removeEffect(MobEffects.NIGHT_VISION);
                }
                entity.removeEffect(MobEffects.INVISIBILITY);
            }
        }
    }

    @Override
    public ParticleOptions getParticle(LevelAccessor levelAccessor) {
        return switch (this.random.nextInt(4)) {
            case 0 -> new DustParticleOptions(Vec3.fromRGB24((int)0x131110).toVector3f(), 3.0f);
            case 1 -> new DustParticleOptions(Vec3.fromRGB24((int)0x111819).toVector3f(), 3.0f);
            case 2 -> new DustParticleOptions(Vec3.fromRGB24((int)723465).toVector3f(), 3.0f);
            default -> new DustParticleOptions(Vec3.fromRGB24((int)1711131).toVector3f(), 3.0f);
        };
    }
}

