/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.bombs;

import com.farcr.nomansland.common.entity.InkCloud;
import com.farcr.nomansland.common.entity.bombs.ThrowableBombEntity;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class InkBomb
extends ThrowableBombEntity {
    private static final float VERTICAL_RESTITUTION = 0.3f;
    private static final float HORIZONTAL_RESTITUTION = 0.4f;

    public InkBomb(EntityType<? extends ThrowableBombEntity> entityType, Level level) {
        super(entityType, level);
    }

    public InkBomb(LivingEntity livingEntity, Level level) {
        super(NMLEntities.INK_BOMB.get(), livingEntity, level);
    }

    public InkBomb(Level level, double x, double y, double z) {
        super(NMLEntities.INK_BOMB.get(), x, y, z, level);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isOnFire()) {
            this.explode();
        }
    }

    @Override
    protected void explode() {
        Level level = this.level();
        level.playSound(null, this.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f) * 0.7f);
        level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.5)).forEach(entity -> {
            entity.hurt(Explosion.getDefaultDamageSource((Level)level, (Entity)this), 4.0f);
            boolean immune = false;
            for (ItemStack stack : entity.getArmorSlots()) {
                if (!stack.is(NMLTags.INK_IMMUNE)) continue;
                immune = true;
                break;
            }
            if (!immune) {
                entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200));
                entity.removeEffect(MobEffects.NIGHT_VISION);
            }
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 1));
            entity.removeEffect(MobEffects.INVISIBILITY);
        });
        InkCloud inkCloud = new InkCloud(this.level(), this.getX(), this.getY() - 1.0, this.getZ());
        Entity owner = this.getOwner();
        if (owner instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)owner;
            inkCloud.setOwner(livingentity);
        }
        inkCloud.setRadius(3.0f);
        inkCloud.setWaitTime(1);
        this.level().addFreshEntity((Entity)inkCloud);
        level.broadcastEntityEvent((Entity)this, (byte)0);
        this.discard();
    }

    public void handleEntityEvent(byte b) {
        if (b == 0) {
            for (int i = 0; i < 40; ++i) {
                double theta = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                double alpha = (double)(this.random.nextFloat() * 2.0f) * Math.PI;
                double cos = Math.cos(alpha);
                double xVelocity = Math.sin(theta) * cos * ((double)this.random.nextFloat() * 0.3 + 0.7);
                double yVelocity = cos * Math.cos(theta) * ((double)this.random.nextFloat() * 0.3 + 0.7);
                double zVelocity = Math.sin(alpha) * ((double)this.random.nextFloat() * 0.3 + 0.7);
                this.level().addParticle(this.getParticle((LevelAccessor)this.level()), false, this.getX(), this.getY(), this.getZ(), xVelocity * 0.1, yVelocity * 0.1, zVelocity * 0.1);
            }
        } else {
            super.handleEntityEvent(b);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        if (!this.level().isClientSide()) {
            this.explode();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Vec3 motion = this.getDeltaMovement();
        if (motion.lengthSqr() < 0.1) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setOnGround(true);
            return;
        }
        Direction direction = result.getDirection();
        switch (direction.getAxis()) {
            case X: {
                this.setDeltaMovement(-motion.x() * (double)0.4f, motion.y(), motion.z());
                break;
            }
            case Y: {
                this.setDeltaMovement(motion.x() * (double)0.3f, -motion.y() * (double)0.3f, motion.z() * (double)0.3f);
                break;
            }
            case Z: {
                this.setDeltaMovement(motion.x(), motion.y(), -motion.z() * (double)0.4f);
            }
        }
        if (!this.shouldFuse()) {
            this.startFuse(30);
        }
    }

    @Override
    protected ParticleOptions getParticle(LevelAccessor levelAccessor) {
        return switch (levelAccessor.getRandom().nextInt(4)) {
            case 0 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)723465);
            case 1 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)0x131110);
            case 2 -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)0x111819);
            default -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)1711131);
        };
    }

    @Override
    public void startFuse(int maxFuse) {
        super.startFuse(maxFuse);
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.TNT_PRIMED, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

