/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.deer;

import com.farcr.nomansland.common.entity.deer.DeerDrinkWaterGoal;
import com.farcr.nomansland.common.registry.NMLSounds;
import com.farcr.nomansland.common.registry.NMLTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Deer
extends Animal {
    private static final String VARIANT_KEY = "Variant";
    private static final String ANTLER_VARIANT_KEY = "AntlersVariant";
    private static final String PATTERN_VARIANT_KEY = "PatternVariant";
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(Deer.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final int FLAG_DRINKING = 1;
    private static final int FLAG_ANTLERS = 1;
    private static final EntityDataAccessor<Integer> DATA_ANTLERS_LIFETIME = SynchedEntityData.defineId(Deer.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int drinkAnimationTick;
    private DeerDrinkWaterGoal drinkGoal;

    public Deer(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
        builder.define(DATA_ANTLERS_LIFETIME, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFlag(1, compound.getBoolean("HasAntlers"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("HasAntlers", this.getFlag(1));
        compound.putInt("AntlersLifetime", ((Integer)this.entityData.get(DATA_ANTLERS_LIFETIME)).intValue());
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.75));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.5));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 12.0f, 1.5, 1.75));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 12.0f, 1.5, 1.75, player -> !player.isDiscrete() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(player)));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Villager.class, 12.0f, 1.5, 1.75));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 12.0f, 1.5, 1.75, livingEntity -> livingEntity instanceof NeutralMob));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.JUMP_STRENGTH, 0.5).add(Attributes.MOVEMENT_SPEED, 0.22).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void customServerAiStep() {
        this.handleAntlers(this.getAntlersLifetime());
        super.customServerAiStep();
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            this.drinkAnimationTick = Math.max(0, this.drinkAnimationTick - 1);
        }
        super.aiStep();
    }

    private void handleHydration(int hydration) {
        if (this.isAlive() && this.isDrinking()) {
            if (hydration < 0) {
                this.setHydration(0);
            } else {
                this.setHydration(hydration + 1);
            }
        } else if (hydration > -1) {
            this.setHydration(hydration - 1);
        }
    }

    private void handleAntlers(int antlersLifeTime) {
        if (!this.isBaby()) {
            this.setAntlersLifetime(this.getAntlersLifetime() + 1);
        }
        if (antlersLifeTime > this.random.nextInt(70000, 80000) && !this.hasAntlers()) {
            this.setHasAntlers(true);
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (!this.isBaby() && (double)this.random.nextFloat() < 0.8) {
            this.setHasAntlers(true);
            this.setAntlersLifetime(this.random.nextInt(0, 36000));
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob otherParent) {
        Deer deer = (Deer)this.getType().create(this.level());
        Deer otherDeer = (Deer)otherParent;
        deer.setHasAntlers(false);
        deer.setAntlersLifetime(0);
        return deer;
    }

    public float getHeadDrinkPositionScale(float partialTick) {
        if (this.drinkAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.drinkAnimationTick >= 4 && this.drinkAnimationTick <= 36) {
            return 1.0f;
        }
        return this.drinkAnimationTick < 4 ? ((float)this.drinkAnimationTick - partialTick) / 4.0f : -((float)(this.drinkAnimationTick - 40) - partialTick) / 4.0f;
    }

    public float getHeadDrinkAngleScale(float partialTick) {
        if (this.drinkAnimationTick > 4 && this.drinkAnimationTick <= 36) {
            float f = ((float)(this.drinkAnimationTick - 4) - partialTick) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.sin((float)(f * 28.7f));
        }
        return this.drinkAnimationTick > 0 ? 0.62831855f : this.getXRot() * ((float)Math.PI / 180);
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(NMLTags.DEER_FOOD);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)NMLSounds.DEER_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)NMLSounds.DEER_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)NMLSounds.DEER_DEATH.get();
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    private void setFlag(int flagId, boolean value) {
        if (value) {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)((Byte)this.entityData.get(DATA_FLAGS_ID) | flagId)));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)((Byte)this.entityData.get(DATA_FLAGS_ID) & ~flagId)));
        }
    }

    private boolean getFlag(int flagId) {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & flagId) != 0;
    }

    public void setHasAntlers(boolean hasAntlers) {
        this.setFlag(1, hasAntlers);
    }

    public boolean hasAntlers() {
        return this.getFlag(1);
    }

    public void setIsDrinking(boolean isDrinking) {
        this.setFlag(1, isDrinking);
    }

    public boolean isDrinking() {
        return this.getFlag(1);
    }

    public int getHydration() {
        return 0;
    }

    public void setHydration(int hydration) {
    }

    public int getAntlersLifetime() {
        return (Integer)this.entityData.get(DATA_ANTLERS_LIFETIME);
    }

    public void setAntlersLifetime(int antlersLifetime) {
        this.entityData.set(DATA_ANTLERS_LIFETIME, (Object)antlersLifetime);
    }
}

