/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.deer;

import com.farcr.nomansland.common.entity.deer.Deer;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;

public class DeerShedAntlersGoal
extends Goal {
    private final Deer mob;
    @Nullable
    protected Path path;
    private final Level level;
    private int shedAnimationTick;

    public DeerShedAntlersGoal(Deer mob) {
        this.mob = mob;
        this.level = mob.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.mob.getAntlersLifetime() > this.mob.getRandom().nextInt(70000, 80000) && this.mob.hasAntlers()) {
            Iterable iterable = BlockPos.betweenClosed((int)Mth.floor((double)(this.mob.getX() - 10.0)), (int)Mth.floor((double)(this.mob.getY() - 10.0)), (int)Mth.floor((double)(this.mob.getZ() - 10.0)), (int)Mth.floor((double)(this.mob.getX() + 10.0)), (int)Mth.floor((double)(this.mob.getY() + 10.0)), (int)Mth.floor((double)(this.mob.getZ() + 10.0)));
            BlockPos blockpos = null;
            for (BlockPos blockpos1 : iterable) {
                if (!this.level.getBlockState(blockpos1).is(BlockTags.LOGS)) continue;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (!this.level.getBlockState(blockpos1.below(2).relative(direction)).isPathfindable(PathComputationType.LAND) || !this.mob.getRandom().nextBoolean()) continue;
                    blockpos = blockpos1.relative(direction).above();
                    break;
                }
                if (blockpos == null) continue;
                this.path = this.mob.getNavigation().createPath((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), 0);
                break;
            }
        }
        return this.path != null;
    }

    public void start() {
        this.shedAnimationTick = this.adjustedTickDelay(this.mob.getRandom().nextInt(40, 120));
        this.level.broadcastEntityEvent((Entity)this.mob, (byte)10);
        this.mob.getNavigation().moveTo(this.path, 1.0);
    }

    public boolean canContinueToUse() {
        return this.mob.hasAntlers() && this.shedAnimationTick > 0;
    }

    public void tick() {
        if (!this.mob.isPathFinding()) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!this.level.getBlockState(this.mob.blockPosition().above().relative(direction)).is(BlockTags.LOGS)) continue;
                this.shedAnimationTick = Math.max(0, this.shedAnimationTick - 1);
                if (this.shedAnimationTick != this.adjustedTickDelay(4)) continue;
                this.mob.setHasAntlers(false);
            }
        }
    }

    public void stop() {
        this.shedAnimationTick = 0;
    }

    public int getShedAnimationTick() {
        return this.shedAnimationTick;
    }
}

