/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.goose;

import com.farcr.nomansland.common.entity.goose.Goose;
import com.farcr.nomansland.common.entity.goose.GooseAI;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class GooseCoreBehavior
extends Behavior<Goose> {
    public GooseCoreBehavior() {
        super(Map.of());
    }

    protected void start(ServerLevel level, Goose goose, long gameTime) {
        Brain<Goose> brain = goose.getBrain();
        NearestVisibleLivingEntities entities = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
        LivingEntity target = brain.getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (target != null && brain.getMemory(MemoryModuleType.WALK_TARGET).isPresent()) {
            if (!goose.canFight()) {
                brain.setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, 80L);
                GooseCoreBehavior.clearCombatMemory(brain, goose);
                goose.setState(Goose.State.IDLING);
            } else {
                goose.setState(Goose.State.RUNNING);
            }
        } else {
            brain.getMemory(MemoryModuleType.HURT_BY_ENTITY).ifPresent(hurtBy -> {
                brain.setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, (Object)hurtBy.getUUID(), 12000L);
                entities.findAll(entity -> entity instanceof Goose).forEach(entity -> entity.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, (Object)hurtBy.getUUID(), 12000L));
            });
            LivingEntity threat = entities.findClosest(entity -> GooseAI.isThreat(entity) && goose.distanceToSqr((Entity)entity) < 9.0).orElse(null);
            if (threat != null) {
                UUID angryAt = brain.getMemory(MemoryModuleType.ANGRY_AT).orElse(null);
                if (threat.isHolding(goose::isFood) || threat.getUUID().equals(angryAt)) {
                    if (goose.canFight()) {
                        brain.setMemoryWithExpiry(MemoryModuleType.ATTACK_TARGET, (Object)threat, 80L);
                        goose.setTarget(threat);
                        brain.eraseMemory(MemoryModuleType.AVOID_TARGET);
                    } else {
                        brain.setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)threat, 80L);
                        GooseCoreBehavior.clearCombatMemory(brain, goose);
                        GooseCoreBehavior.intimidatedBy(brain, goose, threat);
                    }
                } else {
                    GooseCoreBehavior.intimidatedBy(brain, goose, threat);
                }
            } else {
                goose.setState(Goose.State.IDLING);
            }
        }
    }

    private static void intimidatedBy(Brain<Goose> brain, Goose goose, LivingEntity entity) {
        goose.setState(Goose.State.INTIMIDATING);
        brain.setMemoryWithExpiry(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)entity, true), 60L);
        brain.setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)entity, 20L);
        brain.setMemoryWithExpiry(MemoryModuleType.IS_PANICKING, (Object)true, 60L);
        goose.getMoveControl().strafe(-0.3f, 0.0f);
        goose.setYRot(Mth.rotateIfNecessary((float)goose.getYRot(), (float)goose.yHeadRot, (float)0.0f));
    }

    private static void clearCombatMemory(Brain<Goose> brain, Goose goose) {
        brain.eraseMemory(MemoryModuleType.ATTACK_TARGET);
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        brain.eraseMemory(MemoryModuleType.PATH);
        goose.setTarget(null);
    }
}

