/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.tortoise;

import com.farcr.nomansland.common.entity.tortoise.ai.TortoiseBreedGoal;
import com.farcr.nomansland.common.entity.tortoise.ai.TortoiseFindSpotToLayEgg;
import com.farcr.nomansland.common.entity.tortoise.ai.TortoiseLayEggGoal;
import com.farcr.nomansland.common.entity.tortoise.ai.TortoiseSearchForDangerGoal;
import com.farcr.nomansland.common.entity.tortoise.ai.TortoiseSleepAndWakeUpGoal;
import com.farcr.nomansland.common.entity.tortoise.ai.TortoiseStayAroundHomeGoal;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.farcr.nomansland.common.registry.items.NMLItems;
import com.google.common.base.Suppliers;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.slf4j.Logger;

public class Tortoise
extends Animal {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Optional<BlockPos>> HOME_POS = SynchedEntityData.defineId(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LAYING_EGG = SynchedEntityData.defineId(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GOING_HOME = SynchedEntityData.defineId(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IN_SHELL = SynchedEntityData.defineId(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SEARCHING = SynchedEntityData.defineId(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Long> HURT_WHEN = SynchedEntityData.defineId(Tortoise.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    @Nullable
    private UUID lastHurtByUUID;
    private static final float BABY_SCALE = 0.3f;
    private static final Supplier<EntityDimensions> BABY_DIMENSIONS = Suppliers.memoize(() -> NMLEntities.TORTOISE.get().getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, NMLEntities.TORTOISE.get().getHeight(), -0.25f)).scale(0.3f));
    private int layEggCounter;
    private int timesFedWhenBaby;
    public final AnimationState hidingAnimationState = new AnimationState();
    public final AnimationState emergingAnimationState = new AnimationState();
    public final AnimationState layingEggAnimationState = new AnimationState();

    public Tortoise(EntityType<? extends Tortoise> entityType, Level level) {
        super(entityType, level);
        this.lookControl = new LookControl((Mob)this){

            public void tick() {
                if (Tortoise.this.inShell() && !Tortoise.this.isSearching()) {
                    return;
                }
                super.tick();
            }
        };
        this.navigation = new GroundPathNavigation((Mob)this, level){

            public boolean isDone() {
                return super.isDone() || Tortoise.this.inShell();
            }
        };
    }

    public static boolean checkTortoiseSpawnRules(EntityType<Tortoise> tortoise, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Tortoise.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new TortoiseSearchForDangerGoal(this));
        this.goalSelector.addGoal(0, (Goal)new TortoiseStayAroundHomeGoal(this, 0.75));
        this.goalSelector.addGoal(1, (Goal)new TortoiseSleepAndWakeUpGoal(this));
        this.goalSelector.addGoal(2, (Goal)new TortoiseBreedGoal(this, 0.5));
        this.goalSelector.addGoal(3, (Goal)new TortoiseLayEggGoal(this));
        this.goalSelector.addGoal(3, (Goal)new TortoiseFindSpotToLayEgg(this, 0.85f));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 0.5, itemStack -> itemStack.is(NMLTags.TORTOISE_FOOD), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 0.5));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.ARMOR, 15.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOME_POS, Optional.empty());
        builder.define(HAS_EGG, (Object)false);
        builder.define(LAYING_EGG, (Object)false);
        builder.define(GOING_HOME, (Object)false);
        builder.define(IN_SHELL, (Object)false);
        builder.define(SEARCHING, (Object)false);
        builder.define(HURT_WHEN, (Object)0L);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(LAYING_EGG)) {
            this.resetAnimations();
            if (this.isLayingEgg()) {
                this.layingEggAnimationState.startIfStopped(this.tickCount);
            }
            this.refreshDimensions();
        }
        if (key.equals(IN_SHELL)) {
            this.resetAnimations();
            if (this.inShell()) {
                this.hidingAnimationState.startIfStopped(this.tickCount);
            } else {
                this.emergingAnimationState.startIfStopped(this.tickCount);
            }
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    public void tick() {
        super.tick();
        long gameTime = this.level().getGameTime();
        if (gameTime - this.getHurtWhen() > 600L && this.inShell() && this.getLastHurtByUUID() != null) {
            this.setSearching(true);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getHomePos() != null) {
            compound.put("home_pos", NbtUtils.writeBlockPos((BlockPos)this.getHomePos()));
        }
        compound.putBoolean("HasEgg", this.hasEgg());
        compound.putBoolean("Searching", this.isSearching());
        compound.putBoolean("InShell", this.inShell());
        compound.putLong("HurtWhen", this.getHurtWhen());
        compound.putLong("EggCount", (long)this.getLayEggCounter());
        compound.putInt("TimesFed", this.getTimesFedWhenBaby());
        if (this.lastHurtByUUID != null) {
            compound.putUUID("HurtByUUID", this.lastHurtByUUID);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        NbtUtils.readBlockPos((CompoundTag)compound, (String)"home_pos").ifPresent(this::setHomePos);
        this.setSearching(compound.getBoolean("Searching"));
        this.retreatShell(compound.getBoolean("InShell"));
        this.setHasEgg(compound.getBoolean("HasEgg"));
        this.setHurtWhen(compound.getInt("HurtWhen"));
        this.setLayEggCounter(compound.getInt("EggCount"));
        if (this.lastHurtByUUID != null) {
            this.lastHurtByUUID = compound.getUUID("HurtByUUID");
        }
        this.setTimesFedWhenBaby(compound.getInt("TimesFed"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.STRUCTURE) {
            this.setHomePos(this.blockPosition());
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.isFood(itemstack)) {
            int i = this.getAge();
            if (!this.level().isClientSide && i == 0 && this.canFallInLove()) {
                this.usePlayerItem(player, hand, itemstack);
                this.setInLove(player);
                return InteractionResult.SUCCESS;
            }
            if (this.isBaby() && this.getTimesFedWhenBaby() < 3 && !this.level().isClientSide) {
                for (int particleCount = 0; particleCount < 5; ++particleCount) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemstack), this.getX() + this.getLookAngle().x / 2.0, this.getY() + this.getLookAngle().y, this.getZ() + this.getLookAngle().z / 2.0, 1, 0.0, 0.0, 0.0, 0.15);
                }
                this.usePlayerItem(player, hand, itemstack);
                this.playSound(SoundEvents.PLAYER_BURP, 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.ageUp(1800);
                ++this.timesFedWhenBaby;
                return InteractionResult.SUCCESS;
            }
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    private void spawnItemParticles(ItemStack stack, int amount) {
    }

    public void setBaby(boolean baby) {
        this.setAge(baby ? -432000 : 0);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.TURTLE_AMBIENT_LAND;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.TURTLE_SWIM;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return this.isBaby() ? SoundEvents.TURTLE_HURT_BABY : SoundEvents.TURTLE_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return this.isBaby() ? SoundEvents.TURTLE_DEATH_BABY : SoundEvents.TURTLE_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        super.playStepSound(pos, block);
    }

    public boolean canFallInLove() {
        return super.canFallInLove() && !this.hasEgg() && !this.inShell();
    }

    protected float nextStep() {
        return this.moveDist + 0.15f;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.3f : 1.0f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)NMLEntities.TORTOISE.get().create((Level)level);
    }

    protected float getKnockback(Entity attacker, DamageSource damageSource) {
        return this.inShell() ? 0.0f : super.getKnockback(attacker, damageSource);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(NMLTags.TORTOISE_FOOD);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() instanceof LivingEntity) {
            if (!this.inShell()) {
                this.setLastHurtByMob((LivingEntity)source.getEntity());
                this.setHurtWhen(this.level().getGameTime());
                this.retreatShell(true);
            } else if (amount > this.getMaxHealth()) {
                amount -= this.getMaxHealth();
                this.playSound(this.getHurtSound(source));
            } else {
                this.playSound(SoundEvents.SHIELD_BLOCK, 1.0f, 0.2f);
                return false;
            }
        }
        return super.hurt(source, amount);
    }

    public void setLastHurtByMob(@Nullable LivingEntity livingEntity) {
        super.setLastHurtByMob(livingEntity);
        if (livingEntity != null) {
            this.setLastHurtByUUID(livingEntity.getUUID());
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive() && this.isLayingEgg() && this.layEggCounter >= 1 && this.layEggCounter % 5 == 0) {
            BlockPos blockpos = this.blockPosition();
            BlockState blockstate = this.level().getBlockState(blockpos.below());
            if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 5; ++i) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.7, (double)blockpos.getZ() + 0.5, 3, ((double)this.getRandom().nextFloat() - 0.5) * 0.08, ((double)this.getRandom().nextFloat() - 0.5) * 0.08, ((double)this.getRandom().nextFloat() - 0.5) * 0.08, (double)0.15f);
                }
                this.playSound(blockstate.getSoundType((LevelReader)this.level(), blockpos.below(), (Entity)this).getPlaceSound());
            }
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        }
    }

    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (!this.isBaby() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.spawnAtLocation(new ItemStack((ItemLike)NMLItems.STURDY_SCUTE.get(), this.random.nextIntBetweenInclusive(1, 2)), 1.0f);
        }
    }

    private void resetAnimations() {
        this.hidingAnimationState.stop();
        this.emergingAnimationState.stop();
        this.layingEggAnimationState.stop();
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return 0.0f;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isBaby() ? BABY_DIMENSIONS.get() : super.getDefaultDimensions(pose);
    }

    public void setHomePos(BlockPos homePos) {
        this.entityData.set(HOME_POS, Optional.ofNullable(homePos));
    }

    public BlockPos getHomePos() {
        return ((Optional)this.entityData.get(HOME_POS)).orElse(null);
    }

    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    public boolean isLayingEgg() {
        return (Boolean)this.entityData.get(LAYING_EGG);
    }

    public boolean inShell() {
        return (Boolean)this.entityData.get(IN_SHELL);
    }

    public void retreatShell(boolean shouldShell) {
        this.entityData.set(IN_SHELL, (Object)shouldShell);
        this.stopInPlace();
    }

    public boolean isSearching() {
        return (Boolean)this.entityData.get(SEARCHING);
    }

    public void setSearching(boolean searching) {
        this.entityData.set(SEARCHING, (Object)searching);
    }

    public void setLayingEgg(boolean isLayingEgg) {
        this.layEggCounter = isLayingEgg ? 1 : 0;
        this.entityData.set(LAYING_EGG, (Object)isLayingEgg);
    }

    public boolean isGoingHome() {
        return (Boolean)this.entityData.get(GOING_HOME);
    }

    public void setGoingHome(boolean isGoingHome) {
        this.entityData.set(GOING_HOME, (Object)isGoingHome);
    }

    public long getHurtWhen() {
        return (Long)this.entityData.get(HURT_WHEN);
    }

    public void setHurtWhen(long hurtWhen) {
        this.entityData.set(HURT_WHEN, (Object)hurtWhen);
    }

    @Nullable
    public UUID getLastHurtByUUID() {
        return this.lastHurtByUUID;
    }

    public void setLastHurtByUUID(@Nullable UUID lastHurtByUUID) {
        this.lastHurtByUUID = lastHurtByUUID;
    }

    public int getLayEggCounter() {
        return this.layEggCounter;
    }

    public void setLayEggCounter(int layEggCounter) {
        this.layEggCounter = layEggCounter;
    }

    public boolean isValidHome(BlockPos pos) {
        return this.level().getBlockState(pos.below()).is(NMLTags.SUITABLE_TORTOISE_HOME) && this.level().getBrightness(LightLayer.BLOCK, pos) < 7 && this.level().getBrightness(LightLayer.SKY, pos) < 7 && !this.level().canSeeSky(pos) && !this.level().getBlockState(pos).is(NMLBlocks.TORTOISE_EGGS);
    }

    public int getTimesFedWhenBaby() {
        return this.timesFedWhenBaby;
    }

    public void setTimesFedWhenBaby(int timesFedWhenBaby) {
        this.timesFedWhenBaby = timesFedWhenBaby;
    }
}

