/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.tortoise.ai;

import com.farcr.nomansland.common.entity.tortoise.Tortoise;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public class TortoiseFindSpotToLayEgg
extends Goal {
    protected final Tortoise tortoise;
    private final double speedModifier;
    private final Level level;
    private boolean failedAttempt = false;
    private int ticksGoalRan;
    private Path path;

    public TortoiseFindSpotToLayEgg(Tortoise mob, double speedModifier) {
        this.tortoise = mob;
        this.speedModifier = speedModifier;
        this.level = mob.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.tortoise.hasEgg() && !this.tortoise.inShell() && this.getHomePos() != null && !this.tortoise.isLayingEgg();
    }

    public boolean canContinueToUse() {
        return this.tortoise.hasEgg() && !this.tortoise.inShell() && !this.failedAttempt && this.path != null && !this.tortoise.isLayingEgg();
    }

    public void tick() {
        if (this.path == null) {
            return;
        }
        ++this.ticksGoalRan;
        BlockPos blockToGo = this.path.getTarget();
        this.tortoise.getNavigation().moveTo(this.path, this.speedModifier);
        this.tortoise.getLookControl().setLookAt(Vec3.atCenterOf((Vec3i)blockToGo));
        if (!this.tortoise.isValidHome(blockToGo) || this.ticksGoalRan >= 600 && !blockToGo.closerToCenterThan((Position)this.tortoise.position(), 1.5) || !this.path.canReach() && blockToGo.closerToCenterThan((Position)this.tortoise.position(), 4.5)) {
            this.tortoise.getNavigation().stop();
            this.failedAttempt = true;
        } else if (blockToGo.closerToCenterThan((Position)this.tortoise.position(), 1.5) || this.tortoise.isValidHome(this.tortoise.blockPosition())) {
            this.tortoise.setLayingEgg(true);
        }
    }

    public void stop() {
        super.stop();
        if (this.failedAttempt) {
            this.tortoise.setHasEgg(false);
        }
        if (this.ticksGoalRan >= 600) {
            this.ticksGoalRan = 0;
        }
    }

    @Nullable
    protected BlockPos getHomePos() {
        if (!this.tortoise.hasEgg()) {
            return null;
        }
        Iterable iterable = BlockPos.betweenClosed((int)Mth.floor((double)(this.tortoise.getX() - 20.0)), (int)Mth.floor((double)(this.tortoise.getY() - 10.0)), (int)Mth.floor((double)(this.tortoise.getZ() - 20.0)), (int)Mth.floor((double)(this.tortoise.getX() + 20.0)), (int)Mth.floor((double)(this.tortoise.getY() + 10.0)), (int)Mth.floor((double)(this.tortoise.getZ() + 20.0)));
        BlockPos blockToGo = null;
        for (BlockPos newPos : iterable) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos horizontalPos = newPos.relative(direction);
                if (!this.level.isEmptyBlock(horizontalPos.above()) || !this.level.getBlockState(horizontalPos).isPathfindable(PathComputationType.LAND) || !this.tortoise.isValidHome(horizontalPos)) continue;
                if (!BlockPos.squareOutSouthEast((BlockPos)horizontalPos).allMatch(this.tortoise::isValidHome)) continue;
                blockToGo = horizontalPos;
                break;
            }
            if (blockToGo == null) continue;
            this.path = this.tortoise.getNavigation().createPath(blockToGo, 0);
            return blockToGo;
        }
        return null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

