/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.event;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.block.FrostedGrassBlock;
import com.farcr.nomansland.common.block.torches.ExtinguishableBlock;
import com.farcr.nomansland.common.entity.ai.EnemyAttackGoal;
import com.farcr.nomansland.common.entity.bombs.Explosive;
import com.farcr.nomansland.common.integration.Mods;
import com.farcr.nomansland.common.registry.NMLCriteriaTriggers;
import com.farcr.nomansland.common.registry.NMLRegistries;
import com.farcr.nomansland.common.registry.NMLSounds;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.entities.NMLEffects;
import com.farcr.nomansland.common.registry.items.NMLArmorMaterials;
import com.farcr.nomansland.common.registry.items.NMLDataComponents;
import com.farcr.nomansland.common.registry.items.NMLItems;
import com.farcr.nomansland.common.registry.worldgen.NMLBiomes;
import com.farcr.nomansland.common.registry.worldgen.NMLFeatures;
import com.farcr.nomansland.common.saved_data.WardedSpacesData;
import com.farcr.nomansland.common.world.densityfunction.LazilyCachedDensityFunctionSeedifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.DefaultBlockInteractionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="nomansland")
public class MiscellaneousEvents {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Direction ladderFacing;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        boolean isExtinguishing = stack.is(ItemTags.SHOVELS) && (Boolean)NMLConfig.TORCH_EXTINGUISHING.get() != false;
        boolean isLighting = stack.is(NMLTags.FIRESTARTERS);
        if (!player.isSpectator() && (isExtinguishing || isLighting)) {
            for (ExtinguishableBlock holder : NMLRegistries.EXTINGUISHABLE_BLOCKS) {
                if (isExtinguishing) {
                    if (!state.is(holder.litBlock())) continue;
                    level.playSound(player, pos, (SoundEvent)NMLSounds.TORCH_EXTINGUISH.get(), SoundSource.BLOCKS, 0.4f, 1.0f);
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    level.setBlockAndUpdate(pos, holder.extinguishedBlock().withPropertiesOf(state));
                    event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                    event.setCanceled(true);
                    break;
                }
                if (!state.is(holder.extinguishedBlock())) continue;
                level.playSound(player, pos, (SoundEvent)NMLSounds.TORCH_LIGHT.get(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                level.setBlockAndUpdate(pos, holder.litBlock().withPropertiesOf(state));
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                event.setCanceled(true);
                break;
            }
        }
        if (stack.is(Blocks.SNOW.asItem()) && !player.isSpectator() && state.is(Blocks.SHORT_GRASS) && !Mods.SNOWREALMAGIC.isLoaded()) {
            level.setBlockAndUpdate(pos, (BlockState)((FrostedGrassBlock)((Object)NMLBlocks.FROSTED_GRASS.get())).defaultBlockState().setValue((Property)FrostedGrassBlock.SNOWLOGGED, (Comparable)Boolean.valueOf(true)));
            stack.consume(1, (LivingEntity)player);
            level.playSound(player, pos, SoundEvents.SNOW_PLACE, SoundSource.PLAYERS, 1.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.6f + 1.2f);
            BlockPos posUnder = pos.below();
            BlockState stateUnder = level.getBlockState(posUnder);
            if (stateUnder.getBlock() instanceof SnowyDirtBlock) {
                level.setBlockAndUpdate(posUnder, (BlockState)stateUnder.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)));
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        }
        if (stack.is(Items.LADDER) && state.is(Blocks.LADDER) && !player.isSpectator() && !player.isCrouching() && !player.isFakePlayer() && (ladderFacing = (Direction)state.getValue((Property)LadderBlock.FACING)) == event.getFace()) {
            BlockPos.MutableBlockPos mutable = pos.below().mutable();
            for (int i = 0; i < (Integer)NMLConfig.MAX_LADDER_PLACEMENT_LENGTH.get(); ++i) {
                BlockState state2 = level.getBlockState((BlockPos)mutable);
                if (state2.is(BlockTags.REPLACEABLE)) {
                    if (state.canSurvive((LevelReader)level, (BlockPos)mutable)) {
                        SoundType soundtype = state.getSoundType((LevelReader)level, pos, (Entity)player);
                        level.playSound(player, (BlockPos)mutable, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                        stack.consume(1, (LivingEntity)player);
                        BlockState ladderState = (BlockState)Blocks.LADDER.defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)ladderFacing);
                        level.setBlockAndUpdate((BlockPos)mutable, ladderState);
                        level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)ladderState));
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                        break;
                    }
                } else if (!state2.is(Blocks.LADDER)) break;
                mutable.move(Direction.DOWN);
            }
        }
        if (stack.is(ItemTags.RAILS) && state.is(BlockTags.RAILS) && !player.isSpectator() && !player.isCrouching() && !player.isFakePlayer()) {
            Direction playerDir = player.getDirection();
            RailShape railShape = null;
            if (state.getBlock() instanceof BaseRailBlock) {
                railShape = (RailShape)state.getValue(((BaseRailBlock)state.getBlock()).getShapeProperty());
            }
            if (railShape != null) {
                int railCount = 0;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (!level.getBlockState(pos.relative(direction)).is(BlockTags.RAILS)) continue;
                    ++railCount;
                }
                BlockPos.MutableBlockPos mutable = pos.mutable();
                for (int i = 0; i <= (Integer)NMLConfig.MAX_RAIL_PLACMENT_LENGTH.get(); ++i) {
                    BlockPos m = mutable.immutable();
                    BlockPos mBelow = m.below();
                    BlockPos mAbove = m.above();
                    BlockPos mBelow2 = mBelow.below();
                    BlockPos mSlopeBase = mBelow.relative(playerDir.getOpposite());
                    BlockState stateBase = level.getBlockState(m);
                    BlockState stateBelow = level.getBlockState(mBelow);
                    BlockState stateAbove = level.getBlockState(mAbove);
                    BlockState stateBelow2 = level.getBlockState(mBelow2);
                    BlockState stateSlopeBase = level.getBlockState(mSlopeBase);
                    if (stateBase.is(BlockTags.RAILS)) {
                        RailShape offsetShape = null;
                        if (stateBase.getBlock() instanceof BaseRailBlock) {
                            offsetShape = (RailShape)stateBase.getValue(((BaseRailBlock)stateBase.getBlock()).getShapeProperty());
                        }
                        if (offsetShape == null) break;
                        if (offsetShape == RailShape.NORTH_EAST) {
                            if (playerDir == Direction.SOUTH) {
                                playerDir = Direction.EAST;
                            } else if (playerDir == Direction.WEST) {
                                playerDir = Direction.NORTH;
                            }
                        } else if (offsetShape == RailShape.NORTH_WEST) {
                            if (playerDir == Direction.SOUTH) {
                                playerDir = Direction.WEST;
                            } else if (playerDir == Direction.EAST) {
                                playerDir = Direction.NORTH;
                            }
                        } else if (offsetShape == RailShape.SOUTH_EAST) {
                            if (playerDir == Direction.NORTH) {
                                playerDir = Direction.EAST;
                            } else if (playerDir == Direction.WEST) {
                                playerDir = Direction.SOUTH;
                            }
                        } else if (offsetShape == RailShape.SOUTH_WEST) {
                            if (playerDir == Direction.NORTH) {
                                playerDir = Direction.WEST;
                            } else if (playerDir == Direction.EAST) {
                                playerDir = Direction.SOUTH;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_NORTH) {
                            if (playerDir == Direction.NORTH) {
                                mutable.move(Direction.UP);
                            } else if (playerDir != Direction.SOUTH) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_SOUTH) {
                            if (playerDir == Direction.SOUTH) {
                                mutable.move(Direction.UP);
                            } else if (playerDir != Direction.NORTH) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_EAST) {
                            if (playerDir == Direction.EAST) {
                                mutable.move(Direction.UP);
                            } else if (playerDir != Direction.WEST) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_WEST) {
                            if (playerDir == Direction.WEST) {
                                mutable.move(Direction.UP);
                            } else if (playerDir != Direction.EAST) {
                                break;
                            }
                        } else if (offsetShape != RailShape.EAST_WEST && offsetShape != RailShape.NORTH_SOUTH) break;
                        mutable.move(playerDir);
                        continue;
                    }
                    if (stateBelow.is(BlockTags.RAILS)) {
                        boolean canGoDown = false;
                        RailShape offsetShape = null;
                        if (stateBelow.getBlock() instanceof BaseRailBlock) {
                            offsetShape = (RailShape)stateBelow.getValue(((BaseRailBlock)stateBelow.getBlock()).getShapeProperty());
                        }
                        if (offsetShape == null) break;
                        if (offsetShape == RailShape.ASCENDING_NORTH) {
                            if (playerDir == Direction.SOUTH) {
                                mutable.move(Direction.DOWN);
                                canGoDown = true;
                            } else if (playerDir != Direction.NORTH) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_SOUTH) {
                            if (playerDir == Direction.NORTH) {
                                mutable.move(Direction.DOWN);
                                canGoDown = true;
                            } else if (playerDir != Direction.SOUTH) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_EAST) {
                            if (playerDir == Direction.WEST) {
                                mutable.move(Direction.DOWN);
                                canGoDown = true;
                            } else if (playerDir != Direction.EAST) {
                                break;
                            }
                        } else if (offsetShape == RailShape.ASCENDING_WEST) {
                            if (playerDir == Direction.EAST) {
                                mutable.move(Direction.DOWN);
                                canGoDown = true;
                            } else if (playerDir != Direction.WEST) break;
                        }
                        if (canGoDown) continue;
                        if (!stateBase.is(BlockTags.REPLACEABLE)) break;
                        if (!MiscellaneousEvents.placeRail(mutable.immutable(), stack, playerDir, level, player)) continue;
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                        break;
                    }
                    if (stateBase.isFaceSturdy((BlockGetter)level, (BlockPos)mutable, Direction.UP, SupportType.RIGID) && stateAbove.is(BlockTags.REPLACEABLE)) {
                        if (!MiscellaneousEvents.placeRail(mutable.immutable().above(), stack, playerDir, level, player)) continue;
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                        break;
                    }
                    if (stateBelow2.isFaceSturdy((BlockGetter)level, mutable.immutable().below(2), Direction.UP, SupportType.RIGID) && stateSlopeBase.isFaceSturdy((BlockGetter)level, mutable.immutable().below().relative(playerDir.getOpposite()), playerDir, SupportType.RIGID) && stateBelow.is(BlockTags.REPLACEABLE)) {
                        if (!MiscellaneousEvents.placeRail(mutable.immutable().below(), stack, playerDir, level, player)) continue;
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                        break;
                    }
                    if (!stateBase.is(BlockTags.REPLACEABLE)) break;
                    if (!MiscellaneousEvents.placeRail(mutable.immutable(), stack, playerDir, level, player)) continue;
                    event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                    event.setCanceled(true);
                    break;
                }
            }
        }
    }

    private static boolean placeRail(BlockPos position, ItemStack stack, Direction playerDir, Level level, Player player) {
        RailShape placedShape;
        BlockState state = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
        switch (playerDir) {
            case NORTH: 
            case SOUTH: {
                RailShape railShape = RailShape.NORTH_SOUTH;
                break;
            }
            case EAST: 
            case WEST: {
                RailShape railShape = RailShape.EAST_WEST;
                break;
            }
            default: {
                RailShape railShape = placedShape = null;
            }
        }
        if (state.getBlock() instanceof BaseRailBlock) {
            state = (BlockState)state.setValue(((BaseRailBlock)state.getBlock()).getShapeProperty(), (Comparable)placedShape);
        }
        if (state.canSurvive((LevelReader)level, position)) {
            SoundType soundtype = state.getSoundType((LevelReader)level, position, (Entity)player);
            level.playSound(player, position, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            stack.consume(1, (LivingEntity)player);
            level.setBlockAndUpdate(position, state);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onFinalizeMobSpawn(FinalizeSpawnEvent event) {
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (serverLevelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)serverLevelAccessor;
            if (event.getSpawnType() == MobSpawnType.NATURAL && event.getEntity() instanceof Monster) {
                WardedSpacesData wardedSpacesData = (WardedSpacesData)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new WardedSpacesData(new ArrayList<BlockPos>(), new ArrayList<Integer>()), WardedSpacesData::create), "warded_spaces");
                event.setSpawnCancelled(wardedSpacesData.isWarded(event.getEntity().blockPosition()));
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            if (((MobEffect)event.getEffect().value()).equals(NMLEffects.PACIFIED.get())) {
                mob.targetSelector.removeAllGoals(goal -> goal instanceof EnemyAttackGoal);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity livingEntity;
        if (event.getEffectInstance() != null && (livingEntity = event.getEntity()) instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            if (((MobEffect)event.getEffectInstance().getEffect().value()).equals(NMLEffects.PACIFIED.get())) {
                mob.targetSelector.removeAllGoals(goal -> goal instanceof EnemyAttackGoal);
            }
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingIncomingDamageEvent event) {
        ItemStack helmet;
        Vec3 vec32;
        ArmorItem armorItem;
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        ItemStack chestplate = entity.getItemBySlot(EquipmentSlot.CHEST);
        Item item = chestplate.getItem();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).getMaterial().is(NMLArmorMaterials.TORTOISE) && (vec32 = source.getSourcePosition()) != null) {
            Vec3 vec3 = entity.calculateViewVector(0.0f, entity.getYHeadRot());
            Vec3 vec31 = vec32.vectorTo(entity.position());
            vec31 = new Vec3(vec31.x, 0.0, vec31.z).normalize();
            if (!source.is(DamageTypeTags.BYPASSES_SHIELD) && vec31.dot(vec3) > 0.0) {
                if (chestplate.get(NMLDataComponents.TIME_WHEN_DISABLED) == null) {
                    return;
                }
                if (entity instanceof Player) {
                    Player playerReal = (Player)entity;
                    playerReal.awardStat(Stats.ITEM_USED.get((Object)chestplate.getItem()));
                }
                if (damage >= 3.0f) {
                    int damageToItem = 1 + Mth.floor((float)damage);
                    InteractionHand interactionhand = entity.getUsedItemHand();
                    if (MiscellaneousEvents.isTortoiseShellDisabled(chestplate, (Entity)entity)) {
                        chestplate.hurtAndBreak(damageToItem, entity, EquipmentSlot.CHEST);
                    }
                    if (chestplate.isEmpty()) {
                        entity.setItemSlot(EquipmentSlot.CHEST, ItemStack.EMPTY);
                        entity.level().playSound(null, entity.blockPosition(), SoundEvents.SHIELD_BREAK, SoundSource.NEUTRAL, 1.0f, 0.2f);
                    }
                }
                event.setCanceled(MiscellaneousEvents.isTortoiseShellDisabled(chestplate, (Entity)entity));
                MiscellaneousEvents.disableTortoiseShell(source, entity, chestplate);
                if (event.isCanceled()) {
                    entity.level().playSound(null, entity.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.NEUTRAL, 1.0f, 0.2f);
                }
            }
        }
        if ((helmet = entity.getItemBySlot(EquipmentSlot.HEAD)).is(NMLItems.ANCIENT_BRONZE_MASK) && source.getEntity() instanceof Player) {
            int punchCount = (Integer)helmet.getOrDefault(NMLDataComponents.PUNCH_COUNT, (Object)0);
            if (punchCount >= 4) {
                entity.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                entity.spawnAtLocation(helmet.copy());
            } else {
                helmet.set(NMLDataComponents.PUNCH_COUNT, (Object)(punchCount + 1));
                helmet.set(NMLDataComponents.PUNCH_COOLDOWN, (Object)100);
            }
        }
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        ArmorItem armorItem;
        LivingEntity entity = event.getEntity();
        ItemStack stack = entity.getItemBySlot(EquipmentSlot.CHEST);
        Item item = stack.getItem();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).getMaterial().is(NMLArmorMaterials.TORTOISE) && entity.isCrouching()) {
            event.setStrength(0.0f);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Post event) {
        LivingEntity entity;
        ItemStack stack;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && (stack = (entity = (LivingEntity)entity2).getItemBySlot(EquipmentSlot.HEAD)).is(NMLItems.ANCIENT_BRONZE_MASK)) {
            int punchCooldown = (Integer)stack.getOrDefault(NMLDataComponents.PUNCH_COOLDOWN, (Object)0);
            if (punchCooldown > 0) {
                stack.set(NMLDataComponents.PUNCH_COOLDOWN, (Object)(punchCooldown - 1));
            } else if ((Integer)stack.getOrDefault(NMLDataComponents.PUNCH_COUNT, (Object)0) > 0) {
                stack.set(NMLDataComponents.PUNCH_COUNT, (Object)0);
            }
            if (entity instanceof Enemy) {
                entity.addEffect(new MobEffectInstance(NMLEffects.PACIFIED, 200, 0, false, true, true));
            }
        }
    }

    @SubscribeEvent
    public static void onAddAttributeTooltips(AddAttributeTooltipsEvent event) {
        if (event.getStack().is(NMLItems.ANCIENT_BRONZE_MASK)) {
            event.addTooltipLines(new Component[]{Component.translatable((String)"nomansland.tooltip.mask.regeneration").withStyle(ChatFormatting.BLUE)});
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        Level level = event.getLevel();
        for (BlockPos pos : event.getAffectedBlocks()) {
            Explosive explosive;
            Entity entity;
            BlockState state = level.getBlockState(pos);
            for (ExtinguishableBlock block : NMLRegistries.EXTINGUISHABLE_BLOCKS) {
                if (!state.is(block.litBlock())) continue;
                level.gameEvent(explosion.getDirectSourceEntity(), (Holder)GameEvent.BLOCK_CHANGE, pos);
                level.setBlock(pos, block.extinguishedBlock().withPropertiesOf(state), 11);
                level.playSound(null, pos, (SoundEvent)NMLSounds.TORCH_EXTINGUISH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                break;
            }
            if (!((entity = event.getExplosion().getDirectSourceEntity()) instanceof Explosive) || !((entity = (explosive = (Explosive)entity).getOwner()) instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!state.is(Tags.Blocks.ORES)) continue;
            ((DefaultBlockInteractionTrigger)NMLCriteriaTriggers.MINE_ORE_WITH_EXPLOSIVE.get()).trigger(serverPlayer, pos);
        }
    }

    @SubscribeEvent
    public static void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (!((Boolean)NMLConfig.TRAMPLING.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockGrow(BlockGrowFeatureEvent event) {
        if (event.getFeature() != null) {
            ResourceKey feature = event.getFeature().getKey();
            List<ResourceKey> regularOakFeatures = List.of(TreeFeatures.OAK, TreeFeatures.OAK_BEES_0002, TreeFeatures.OAK_BEES_002, TreeFeatures.OAK_BEES_005);
            List<ResourceKey> fancyOakFeatures = List.of(TreeFeatures.FANCY_OAK, TreeFeatures.FANCY_OAK_BEES_0002, TreeFeatures.FANCY_OAK_BEES_002, TreeFeatures.FANCY_OAK_BEES_005);
            List<ResourceKey<ConfiguredFeature<?, ?>>> autumnalOakFeatures = List.of(NMLFeatures.AUTUMNAL_OAK, NMLFeatures.LARGE_AUTUMNAL_OAK);
            List<ResourceKey> spruceFeatures = List.of(TreeFeatures.SPRUCE, TreeFeatures.MEGA_SPRUCE, TreeFeatures.PINE, TreeFeatures.MEGA_PINE);
            List<ResourceKey<ConfiguredFeature<?, ?>>> pineFeatures = List.of(NMLFeatures.PINE, NMLFeatures.LARGE_PINE);
            BlockPos pos = event.getPos();
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            LevelAccessor level = event.getLevel();
            int fruit = 0;
            RandomSource random = event.getRandom();
            boolean apple = regularOakFeatures.contains(feature) || fancyOakFeatures.contains(feature);
            boolean pear = autumnalOakFeatures.contains(feature);
            if (apple || pear) {
                Iterator it = BlockPos.betweenClosedStream((int)(x - 8), (int)(y - 12), (int)(z - 8), (int)(x + 8), (int)(y + 12), (int)(z + 8)).iterator();
                while (it.hasNext()) {
                    BlockPos bp = (BlockPos)it.next();
                    BlockState state = level.getBlockState(bp);
                    if (apple && state.is(NMLBlocks.APPLE_FRUIT.block())) {
                        ++fruit;
                    }
                    if (!pear || !state.is(NMLBlocks.PEAR_FRUIT.block())) continue;
                    ++fruit;
                }
                if (fruit >= 12) {
                    if (regularOakFeatures.contains(feature)) {
                        event.setFeature(NMLFeatures.OAK_APPLE_05);
                    }
                    if (fancyOakFeatures.contains(feature)) {
                        event.setFeature(NMLFeatures.FANCY_OAK_APPLE_05);
                    }
                    if (feature == NMLFeatures.AUTUMNAL_OAK) {
                        event.setFeature(NMLFeatures.AUTUMNAL_OAK_PEAR_05);
                    }
                    if (feature == NMLFeatures.LARGE_AUTUMNAL_OAK) {
                        event.setFeature(NMLFeatures.LARGE_AUTUMNAL_OAK_PEAR_05);
                    }
                } else if (random.nextBoolean() && fruit >= 6) {
                    if (regularOakFeatures.contains(feature)) {
                        event.setFeature(NMLFeatures.OAK_APPLE_05);
                    }
                    if (fancyOakFeatures.contains(feature)) {
                        event.setFeature(NMLFeatures.FANCY_OAK_APPLE_05);
                    }
                    if (feature == NMLFeatures.AUTUMNAL_OAK) {
                        event.setFeature(NMLFeatures.AUTUMNAL_OAK_PEAR_05);
                    }
                    if (feature == NMLFeatures.LARGE_AUTUMNAL_OAK) {
                        event.setFeature(NMLFeatures.LARGE_AUTUMNAL_OAK_PEAR_05);
                    }
                } else if (fruit > 0) {
                    if (regularOakFeatures.contains(feature)) {
                        event.setFeature(NMLFeatures.OAK_APPLE_01);
                    }
                    if (fancyOakFeatures.contains(feature)) {
                        event.setFeature(NMLFeatures.FANCY_OAK_APPLE_01);
                    }
                }
            }
            if ((spruceFeatures.contains(feature) || pineFeatures.contains(feature)) && level.getLevelData().isRaining() && !((Biome)level.getBiome(pos).value()).warmEnoughToRain(pos)) {
                if (spruceFeatures.contains(feature)) {
                    if (feature == TreeFeatures.SPRUCE) {
                        event.setFeature(NMLFeatures.FROSTED_SPRUCE);
                    }
                    if (feature == TreeFeatures.MEGA_SPRUCE) {
                        event.setFeature(NMLFeatures.MEGA_FROSTED_SPRUCE);
                    }
                    if (feature == TreeFeatures.PINE) {
                        event.setFeature(NMLFeatures.FROSTED_SPRUCE_ALT);
                    }
                    if (feature == TreeFeatures.MEGA_PINE) {
                        event.setFeature(NMLFeatures.MEGA_FROSTED_SPRUCE_ALT);
                    }
                }
                if (pineFeatures.contains(feature)) {
                    event.setFeature(NMLFeatures.FROSTED_PINE);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerStart(ServerAboutToStartEvent event) {
        NMLBiomes.CAVES_HOLDER = event.getServer().registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(NMLBiomes.CAVES);
        NMLBiomes.CAVE_DEPTHS_HOLDER = event.getServer().registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(NMLBiomes.CAVE_DEPTHS);
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppingEvent event) {
        LazilyCachedDensityFunctionSeedifier.clearCache();
    }

    public static void spawnItemParticles(int amount, RandomSource randomSource, Level level, ItemStack itemstack, LivingEntity entity) {
        for (int i = 0; i < amount; ++i) {
            Vec3 vec3 = new Vec3(((double)randomSource.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.xRot(-entity.getXRot() * ((float)Math.PI / 180));
            vec3 = vec3.yRot(-entity.getYRot() * ((float)Math.PI / 180));
            double d0 = (double)(-randomSource.nextFloat()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)randomSource.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.xRot(-entity.getXRot() * ((float)Math.PI / 180));
            vec31 = vec31.yRot(-entity.getYRot() * ((float)Math.PI / 180));
            vec31 = vec31.add(entity.getX(), entity.getEyeY(), entity.getZ());
            if (itemstack.isEmpty()) continue;
            ((ServerLevel)level).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemstack), vec31.x, vec31.y, vec31.z, amount, vec3.x, vec3.y + 0.05, vec3.z, 0.5);
        }
    }

    public static void disableTortoiseShell(DamageSource source, LivingEntity entity, ItemStack stack) {
        LivingEntity living;
        if (stack.isEmpty() || !stack.isEmpty() && stack.get(NMLDataComponents.TIME_WHEN_DISABLED) != null && entity.level().getGameTime() - (Long)stack.get(NMLDataComponents.TIME_WHEN_DISABLED) < 100L) {
            return;
        }
        Entity entity2 = source.getEntity();
        if (entity2 instanceof LivingEntity && (living = (LivingEntity)entity2).getItemBySlot(EquipmentSlot.MAINHAND).canDisableShield(living.getItemBySlot(EquipmentSlot.MAINHAND), entity, living)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.getCooldowns().addCooldown(stack.getItem(), 100);
            }
            stack.set((DataComponentType)NMLDataComponents.TIME_WHEN_DISABLED.get(), (Object)entity.level().getGameTime());
            MiscellaneousEvents.spawnItemParticles(5, living.getRandom(), living.level(), stack, living);
            entity.level().playSound(null, entity.blockPosition(), SoundEvents.SHIELD_BREAK, SoundSource.NEUTRAL, 1.0f, 0.2f);
        }
    }

    public static boolean isTortoiseShellDisabled(ItemStack stack, Entity entity) {
        if (stack.get(NMLDataComponents.TIME_WHEN_DISABLED) == null) {
            return false;
        }
        return entity.level().getGameTime() - (Long)stack.get(NMLDataComponents.TIME_WHEN_DISABLED) > 100L;
    }
}

