/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.Graph;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FeatureSorter.class}, priority=900)
public class FeatureSorterMixin {
    @Unique
    private static <T> List<FeatureSorter.StepFeatureData> no_Mans_Land$buildFeaturesPerStep(List<T> biomes, Function<T, List<HolderSet<PlacedFeature>>> biomeToFeatureSetFunction) {
        Object2IntOpenHashMap indexMap = new Object2IntOpenHashMap();
        MutableInt mutableint = new MutableInt(0);
        record FeatureData(int featureIndex, int step, PlacedFeature feature) {
        }
        Comparator<FeatureData> comparator = Comparator.comparingInt(FeatureData::step).thenComparingInt(FeatureData::featureIndex);
        TreeMap<FeatureData, Set> dependencyMap = new TreeMap<FeatureData, Set>(comparator);
        int maxBiomeFeatureCount = 0;
        for (T biome : biomes) {
            ArrayList featureDataList = Lists.newArrayList();
            List<HolderSet<PlacedFeature>> featureSet = biomeToFeatureSetFunction.apply(biome);
            maxBiomeFeatureCount = Math.max(maxBiomeFeatureCount, featureSet.size());
            for (int j = 0; j < featureSet.size(); ++j) {
                for (Holder holder : (HolderSet)featureSet.get(j)) {
                    PlacedFeature placedfeature = (PlacedFeature)holder.value();
                    featureDataList.add(new FeatureData(indexMap.computeIfAbsent((Object)placedfeature, p_220609_ -> mutableint.getAndIncrement()), j, placedfeature));
                }
            }
            for (int k = 0; k < featureDataList.size(); ++k) {
                Set featureDataSet = dependencyMap.computeIfAbsent((FeatureData)featureDataList.get(k), p_220602_ -> new TreeSet(comparator));
                if (k >= featureDataList.size() - 1) continue;
                featureDataSet.add((FeatureData)featureDataList.get(k + 1));
            }
        }
        TreeSet<FeatureData> visitedNodesUnique = new TreeSet<FeatureData>(comparator);
        TreeSet<FeatureData> currentPathNodes = new TreeSet<FeatureData>(comparator);
        ArrayList visitedNodes = Lists.newArrayList();
        for (FeatureData featureData : dependencyMap.keySet()) {
            if (!currentPathNodes.isEmpty()) {
                throw new IllegalStateException("You somehow broke the universe; DFS bork (iteration finished with non-empty in-progress vertex set");
            }
            if (visitedNodesUnique.contains(featureData)) continue;
            if (!Graph.depthFirstSearch(dependencyMap, visitedNodesUnique, currentPathNodes, visitedNodes::add, (Object)featureData)) continue;
            for (FeatureData pathNode : currentPathNodes) {
                if (!visitedNodesUnique.add(pathNode)) continue;
                visitedNodes.add(pathNode);
            }
            currentPathNodes = new TreeSet<FeatureData>(comparator);
        }
        Collections.reverse(visitedNodes);
        ImmutableList.Builder builder = ImmutableList.builder();
        int l = 0;
        while (l < maxBiomeFeatureCount) {
            int i1 = l++;
            List list4 = visitedNodes.stream().filter(p_220599_ -> p_220599_.step() == i1).map(FeatureData::feature).collect(Collectors.toList());
            builder.add((Object)new FeatureSorter.StepFeatureData(list4, Util.createIndexIdentityLookup(list4)));
        }
        return builder.build();
    }

    @Inject(method={"buildFeaturesPerStep"}, at={@At(value="HEAD")}, cancellable=true)
    private static void replaceFeaturesPerStep(List<Holder<Biome>> featureSetSources, Function<Holder<Biome>, List<HolderSet<PlacedFeature>>> toFeatueSetFunction, boolean notRecursiveFlag, CallbackInfoReturnable<List<FeatureSorter.StepFeatureData>> cir) {
        cir.setReturnValue(FeatureSorterMixin.no_Mans_Land$buildFeaturesPerStep(featureSetSources, toFeatueSetFunction));
    }
}

