/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LadderBlock.class})
public abstract class LadderBlockMixin {
    @Shadow
    public abstract boolean canAttachTo(BlockGetter var1, BlockPos var2, Direction var3);

    @Inject(method={"canAttachTo"}, at={@At(value="HEAD")}, cancellable=true)
    protected void nml$canAttachTo(BlockGetter blockReader, BlockPos pos, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        BlockPos.MutableBlockPos mutableL = pos.relative(direction).mutable();
        BlockState blockState = blockReader.getBlockState((BlockPos)mutable);
        if (blockState.isFaceSturdy(blockReader, (BlockPos)mutable, direction) || blockState.isFaceSturdy(blockReader, (BlockPos)mutable, Direction.UP)) {
            cir.setReturnValue((Object)true);
            return;
        }
        while (mutable.getY() < blockReader.getMaxBuildHeight()) {
            mutable.move(Direction.UP);
            mutableL.move(Direction.UP);
            BlockState ladderState = blockReader.getBlockState((BlockPos)mutableL);
            if (!ladderState.hasProperty((Property)LadderBlock.FACING) || ladderState.getValue((Property)LadderBlock.FACING) != direction) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (!this.canAttachTo(blockReader, (BlockPos)mutable, direction)) continue;
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")}, cancellable=true)
    protected void nml$updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> cir) {
        if (!state.canSurvive((LevelReader)level, currentPos)) {
            cir.setReturnValue((Object)Blocks.AIR.defaultBlockState());
        }
    }
}

