/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import com.farcr.nomansland.common.block.torches.ExtinguishedSconceTorchBlock;
import com.farcr.nomansland.common.block.torches.ExtinguishedSconceWallTorchBlock;
import com.farcr.nomansland.common.block.torches.ExtinguishedTorchBlock;
import com.farcr.nomansland.common.block.torches.ExtinguishedWallTorchBlock;
import com.farcr.nomansland.common.mixin.EntityMixin;
import com.farcr.nomansland.common.registry.NMLSounds;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThrownPotion.class})
public abstract class ThrownPotionMixin
extends EntityMixin {
    @Inject(method={"dowseFire"}, at={@At(value="TAIL")})
    private void extinguishTorches(BlockPos pos, CallbackInfo ci) {
        BlockState state = this.level().getBlockState(pos);
        if (state.getBlock() instanceof TorchBlock && !(state.getBlock() instanceof ExtinguishedTorchBlock)) {
            this.level().gameEvent(((ThrownPotion)this).getOwner(), (Holder)GameEvent.BLOCK_CHANGE, pos);
            this.level().playSound(null, pos, (SoundEvent)NMLSounds.TORCH_EXTINGUISH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (state.is(Blocks.TORCH)) {
                this.level().setBlock(pos, ((ExtinguishedTorchBlock)((Object)NMLBlocks.EXTINGUISHED_TORCH.get())).withPropertiesOf(state), 11);
            }
            if (state.is(Blocks.WALL_TORCH)) {
                this.level().setBlock(pos, ((ExtinguishedWallTorchBlock)((Object)NMLBlocks.EXTINGUISHED_WALL_TORCH.get())).withPropertiesOf(state), 11);
            }
            if (state.is(Blocks.SOUL_TORCH)) {
                this.level().setBlock(pos, ((ExtinguishedTorchBlock)((Object)NMLBlocks.EXTINGUISHED_SOUL_TORCH.get())).withPropertiesOf(state), 11);
            }
            if (state.is(Blocks.SOUL_WALL_TORCH)) {
                this.level().setBlock(pos, ((ExtinguishedWallTorchBlock)((Object)NMLBlocks.EXTINGUISHED_SOUL_WALL_TORCH.get())).withPropertiesOf(state), 11);
            }
            if (state.is(NMLBlocks.SCONCE_TORCH.block())) {
                this.level().setBlock(pos, ((ExtinguishedSconceTorchBlock)((Object)NMLBlocks.EXTINGUISHED_SCONCE_TORCH.get())).withPropertiesOf(state), 11);
            }
            if (state.is(NMLBlocks.SCONCE_WALL_TORCH.block())) {
                this.level().setBlock(pos, ((ExtinguishedSconceWallTorchBlock)((Object)NMLBlocks.EXTINGUISHED_SCONCE_WALL_TORCH.get())).withPropertiesOf(state), 11);
            }
            if (state.is(NMLBlocks.SCONCE_SOUL_TORCH.block())) {
                this.level().setBlock(pos, ((ExtinguishedSconceTorchBlock)((Object)NMLBlocks.EXTINGUISHED_SCONCE_SOUL_TORCH.get())).withPropertiesOf(state), 11);
            }
            if (state.is(NMLBlocks.SCONCE_SOUL_WALL_TORCH.block())) {
                this.level().setBlock(pos, ((ExtinguishedSconceWallTorchBlock)((Object)NMLBlocks.EXTINGUISHED_SCONCE_SOUL_WALL_TORCH.get())).withPropertiesOf(state), 11);
            }
        }
    }
}

