/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin.client;

import com.farcr.nomansland.common.registry.items.NMLItems;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public abstract class HumanoidModelMixin<T extends LivingEntity>
extends AgeableListModel<T>
implements ArmedModel,
HeadedModel {
    @Shadow
    @Final
    public ModelPart leftArm;
    @Shadow
    @Final
    public ModelPart rightArm;
    @Shadow
    @Final
    public ModelPart rightLeg;
    @Shadow
    @Final
    public ModelPart leftLeg;
    @Shadow
    public HumanoidModel.ArmPose leftArmPose;
    @Shadow
    public HumanoidModel.ArmPose rightArmPose;

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="TAIL")}, cancellable=true)
    private void setupAnims(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (entity.getItemBySlot(EquipmentSlot.CHEST).is((Item)NMLItems.TORTOISE_SHELL.get()) && this.attackTime <= 0.0f) {
            boolean leftArmPosed;
            boolean flag = entity.getFallFlyingTicks() > 4;
            float f = 1.0f;
            if (flag) {
                f = (float)entity.getDeltaMovement().lengthSqr();
                f /= 0.2f;
                f *= f * f;
            }
            if (f < 1.0f) {
                f = 1.0f;
            }
            float movementRight = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f;
            float movementLeft = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f;
            boolean rightArmPosed = this.rightArmPose != HumanoidModel.ArmPose.EMPTY && this.rightArmPose != HumanoidModel.ArmPose.ITEM;
            boolean bl = leftArmPosed = this.leftArmPose != HumanoidModel.ArmPose.EMPTY && this.leftArmPose != HumanoidModel.ArmPose.ITEM;
            if (!rightArmPosed && !this.leftArmPose.isTwoHanded()) {
                this.rightArm.xRot = movementRight <= 0.0f ? -Math.abs(movementRight) : 0.0f;
            }
            if (!leftArmPosed && !this.rightArmPose.isTwoHanded()) {
                this.leftArm.xRot = movementRight >= 0.0f ? -Math.abs(movementLeft) : 0.0f;
            }
        }
    }
}

