/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.densityfunction.modification;

import com.farcr.nomansland.common.world.densityfunction.modification.DensityFunctionModifier;
import com.farcr.nomansland.common.world.densityfunction.modification.NoiseRouterParameter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;

public class DensityFunctionModifications {
    public static Map<ResourceKey<DimensionType>, NoiseRouterModifications> NOISE_ROUTER_MODIFICATIONS = new HashMap<ResourceKey<DimensionType>, NoiseRouterModifications>();
    public static Map<ResourceKey<DensityFunction>, DensityFunctionModifier> MODIFIERS = new HashMap<ResourceKey<DensityFunction>, DensityFunctionModifier>();

    public static void addModifier(ResourceKey<DensityFunction> target, DensityFunctionModifier modifier) {
        if (MODIFIERS.containsKey(target)) {
            MODIFIERS.merge(target, modifier, DensityFunctionModifier::combine);
        } else {
            MODIFIERS.put(target, modifier);
        }
    }

    public static void addNoiseRouterParameterModifier(ResourceKey<DimensionType> targetDimension, NoiseRouterParameter targetParameter, DensityFunctionModifier modifier) {
        if (NOISE_ROUTER_MODIFICATIONS.containsKey(targetDimension)) {
            NOISE_ROUTER_MODIFICATIONS.get(targetDimension).addModifier(targetParameter, modifier);
        } else {
            NoiseRouterModifications modifications = new NoiseRouterModifications();
            modifications.addModifier(targetParameter, modifier);
            NOISE_ROUTER_MODIFICATIONS.put(targetDimension, modifications);
        }
    }

    public static class NoiseRouterModifications {
        public Map<NoiseRouterParameter, DensityFunctionModifier> modifiers = new HashMap<NoiseRouterParameter, DensityFunctionModifier>();

        private NoiseRouterModifications() {
        }

        private void addModifier(NoiseRouterParameter target, DensityFunctionModifier modifier) {
            if (this.modifiers.containsKey((Object)target)) {
                this.modifiers.merge(target, modifier, DensityFunctionModifier::combine);
            } else {
                this.modifiers.put(target, modifier);
            }
        }
    }
}

