/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature;

import com.farcr.nomansland.common.world.feature.MultiSpreadPatchConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class MultiSpreadPatchFeature
extends Feature<MultiSpreadPatchConfiguration> {
    public MultiSpreadPatchFeature(Codec<MultiSpreadPatchConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<MultiSpreadPatchConfiguration> context) {
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        MultiSpreadPatchConfiguration config = (MultiSpreadPatchConfiguration)context.config();
        float tryDensity = config.tryDensity();
        int xzSpread = config.xzSpread().sample(random);
        int ySpread = config.ySpread().sample(random);
        int tries = Math.round((float)(xzSpread * xzSpread * ySpread) * tryDensity);
        double sparseness = config.sparseness();
        double randomness = config.randomness();
        BlockPos.MutableBlockPos pos = origin.mutable();
        for (int i = 0; i < tries; ++i) {
            int x = (int)((double)origin.getX() + Math.clamp(random.nextGaussian(), -sparseness, sparseness) / sparseness * (double)xzSpread);
            int z = (int)((double)origin.getZ() + Math.clamp(random.nextGaussian(), -sparseness, sparseness) / sparseness * (double)xzSpread);
            int y = origin.getY() + random.nextInt(-ySpread, ySpread);
            pos.set(x, y, z);
            if (Math.abs(x - origin.getX()) > 16 || Math.abs(z - origin.getZ()) > 16) break;
            float distanceFromOriginXZ = Mth.sqrt((float)((x - origin.getX()) * (x - origin.getX()) + (z - origin.getZ()) * (z - origin.getZ())));
            float modifiedDistanceFromOriginXZ = Mth.sqrt((float)Mth.clamp((float)(distanceFromOriginXZ / ((float)xzSpread * Mth.SQRT_OF_TWO)), (float)0.0f, (float)1.0f));
            modifiedDistanceFromOriginXZ = Mth.clamp((float)(modifiedDistanceFromOriginXZ + (2.0f * random.nextFloat() - 1.0f) * (float)randomness), (float)0.0f, (float)1.0f);
            int index = Math.min(Mth.floor((float)(modifiedDistanceFromOriginXZ * (float)config.features().size())), config.features().size() - 1);
            if (!((double)distanceFromOriginXZ < 24.0) || !((double)modifiedDistanceFromOriginXZ < 24.0)) continue;
            ((PlacedFeature)config.features().get(index).value()).place(level, context.chunkGenerator(), random, (BlockPos)pos);
        }
        return true;
    }
}

