/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature;

import com.farcr.nomansland.common.block.CaveFoliageBlock;
import com.farcr.nomansland.common.entity.tortoise.Tortoise;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.farcr.nomansland.common.registry.worldgen.NMLBiomes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tazer.mixed_litter.VariantUtil;
import dev.tazer.mixed_litter.registry.MLDataAttachmentTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class TortoiseBurrowFeature
extends Feature<Configuration> {
    private static final BlockState AIR = Blocks.CAVE_AIR.defaultBlockState();

    public TortoiseBurrowFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        BlockPos.MutableBlockPos blockpos = context.origin().mutable();
        WorldGenLevel worldgenlevel = context.level();
        RandomSource randomsource = context.random();
        Configuration configuration = (Configuration)context.config();
        BlockState blockToPlace = configuration.validBlocks().get(randomsource.nextInt(configuration.validBlocks().size())).getState(randomsource, (BlockPos)blockpos);
        if (!this.canPlace(worldgenlevel, (BlockPos)blockpos)) {
            return false;
        }
        boolean tortoiseSpawned = false;
        ArrayList<BlockPos.MutableBlockPos> filledPos = new ArrayList<BlockPos.MutableBlockPos>();
        Direction direction = this.findEntranceDirection(worldgenlevel, (BlockPos)blockpos);
        if (direction == null) {
            return false;
        }
        int maxOffset = randomsource.nextIntBetweenInclusive(3, 5);
        for (int offsetPos = 0; offsetPos <= maxOffset; ++offsetPos) {
            BlockPos offsetBlockPos = blockpos.relative(direction, offsetPos);
            if (offsetPos != 0) {
                offsetBlockPos = offsetBlockPos.relative(direction, 4);
            }
            if (offsetPos == maxOffset) {
                offsetBlockPos = offsetBlockPos.relative(direction, 3).below(2);
            }
            Direction randomDirection = Direction.from2DDataValue((int)randomsource.nextInt(4));
            while (randomDirection == direction || randomDirection == direction.getOpposite()) {
                randomDirection = Direction.from2DDataValue((int)randomsource.nextInt(4));
            }
            filledPos.add(offsetBlockPos.mutable().move(randomDirection));
        }
        if (filledPos.stream().noneMatch(blockPos -> blockPos != filledPos.getFirst() && !this.checkIfAllSolid(worldgenlevel, (BlockPos)blockPos, 5.0, 5.0, 5.0))) {
            if (!filledPos.isEmpty() && filledPos.size() > 2) {
                ArrayList<BlockPos> airPos = new ArrayList<BlockPos>();
                for (int listEntry = 0; listEntry < filledPos.size(); ++listEntry) {
                    Tortoise tortoise;
                    BlockState stoneState;
                    BlockPos listedPos = (BlockPos)filledPos.get(listEntry);
                    BlockPos tortoiseSpawnPos = (BlockPos)filledPos.getLast();
                    BlockState blockState = stoneState = listedPos.getY() <= 0 || worldgenlevel.getBiome(listedPos).is(NMLBiomes.CAVE_DEPTHS) ? Blocks.DEEPSLATE.defaultBlockState() : Blocks.STONE.defaultBlockState();
                    if (listedPos != tortoiseSpawnPos) {
                        this.placeBurrow(5.0, 5.0, 5.0, listedPos, worldgenlevel, stoneState, randomsource, listedPos != filledPos.getFirst(), stoneState, direction.getOpposite(), airPos, 1, 3);
                    }
                    if (!tortoiseSpawned && (tortoise = (Tortoise)NMLEntities.TORTOISE.get().create((Level)worldgenlevel.getLevel())) != null) {
                        tortoiseSpawned = true;
                        tortoise.moveTo(tortoiseSpawnPos.getX(), tortoiseSpawnPos.getY(), tortoiseSpawnPos.getZ(), 0.0f, 0.0f);
                        tortoise.finalizeSpawn((ServerLevelAccessor)worldgenlevel, worldgenlevel.getCurrentDifficultyAt((BlockPos)blockpos), MobSpawnType.STRUCTURE, null);
                        tortoise.setHomePos(tortoiseSpawnPos);
                        tortoise.setData(MLDataAttachmentTypes.SPAWN_LOCATION, GlobalPos.of((ResourceKey)tortoise.level().dimension(), (BlockPos)tortoise.blockPosition()));
                        VariantUtil.applySuitableVariants((Entity)tortoise);
                        worldgenlevel.addFreshEntityWithPassengers((Entity)tortoise);
                    }
                    this.placeBurrow(5.0, 5.0, 5.0, tortoiseSpawnPos, worldgenlevel, blockToPlace, randomsource, true, stoneState, direction.getOpposite(), airPos, 3, 2);
                }
                for (BlockPos blockPos2 : airPos) {
                    if (worldgenlevel.getBlockState(blockPos2).is((Block)NMLBlocks.CAVE_WEEDS.get())) continue;
                    worldgenlevel.setBlock(blockPos2, AIR, 2);
                }
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    private boolean checkIfAllSolid(WorldGenLevel level, BlockPos origin, double radiusX, double radiusY, double radiusZ) {
        ArrayList<BlockPos.MutableBlockPos> filledPos = new ArrayList<BlockPos.MutableBlockPos>();
        for (int x = -8; x < 8; ++x) {
            for (int y = -4; y < 5; ++y) {
                for (int z = -8; z < 8; ++z) {
                    double dX = (double)x / (radiusX / 2.0);
                    double dY = (double)y / (radiusY / 2.0);
                    double dZ = (double)z / (radiusZ / 2.0);
                    double distance = dX * dX + dY * dY + dZ * dZ;
                    BlockPos.MutableBlockPos selectedPos = origin.offset(x, y, z).mutable();
                    if (!(distance < 1.0)) continue;
                    filledPos.add(selectedPos);
                }
            }
        }
        return filledPos.stream().allMatch(blockPos -> !level.isEmptyBlock(blockPos) && level.getFluidState(blockPos).isEmpty());
    }

    private Direction findEntranceDirection(WorldGenLevel level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!direction.getAxis().isHorizontal()) continue;
            for (int offsetPos = 0; offsetPos < 4; ++offsetPos) {
                ArrayList<BlockPos> checkedPositions = new ArrayList<BlockPos>();
                BlockPos airPos = pos.relative(direction, offsetPos);
                checkedPositions.add(airPos);
                if (!checkedPositions.stream().allMatch(arg_0 -> ((WorldGenLevel)level).isEmptyBlock(arg_0))) continue;
                return direction.getOpposite();
            }
        }
        return null;
    }

    private void placeBurrow(double radiusX, double radiusY, double radiusZ, BlockPos origin, WorldGenLevel level, BlockState blockToPlace, RandomSource randomSource, boolean shouldBarrier, BlockState barrierState, Direction direction, List<BlockPos> airPos, int entranceOffset, int entranceFowardOffset) {
        double distance;
        double dZ;
        double dY;
        double dX;
        int z;
        int y;
        int x;
        for (x = -8; x < 8; ++x) {
            for (y = -4; y < 5; ++y) {
                for (z = -8; z < 8; ++z) {
                    boolean isTopLayer;
                    dX = (double)x / (radiusX / 2.0);
                    dY = (double)y / (radiusY / 2.0);
                    dZ = (double)z / (radiusZ / 2.0);
                    distance = dX * dX + dY * dY + dZ * dZ;
                    BlockPos.MutableBlockPos selectedPos = origin.offset(x, y, z).mutable();
                    Direction[] currentState = level.getBlockState((BlockPos)selectedPos);
                    BlockState belowState = level.getBlockState(selectedPos.below());
                    if (!(distance < 1.0) || !this.canReplaceBlock((BlockState)currentState)) continue;
                    boolean bl = isTopLayer = (double)y >= 0.0;
                    if (!isTopLayer) {
                        if (belowState.isAir()) {
                            selectedPos.move(Direction.DOWN);
                        }
                        level.setBlock((BlockPos)selectedPos, blockToPlace, 2);
                        continue;
                    }
                    level.setBlock((BlockPos)selectedPos, AIR, 2);
                    for (Direction aroundDirection : Direction.values()) {
                        if (aroundDirection == direction || aroundDirection == direction.getOpposite()) continue;
                        BlockPos toAlsoDelete = origin.relative(direction, entranceFowardOffset).above(entranceOffset);
                        BlockPos aroundOrigin = toAlsoDelete.relative(aroundDirection);
                        airPos.add(aroundOrigin);
                        airPos.add(aroundOrigin.above());
                        airPos.add(toAlsoDelete);
                        airPos.add(toAlsoDelete.above());
                    }
                    airPos.add((BlockPos)selectedPos);
                    if (!level.getBlockState(selectedPos.below()).isSolid() || randomSource.nextInt(5) != 0) continue;
                    level.setBlock((BlockPos)selectedPos, ((CaveFoliageBlock)((Object)NMLBlocks.CAVE_WEEDS.get())).defaultBlockState(), 2);
                }
            }
        }
        if (shouldBarrier) {
            for (x = -8; x < 8; ++x) {
                for (y = -4; y < 4; ++y) {
                    for (z = -8; z < 8; ++z) {
                        boolean flag;
                        dX = (double)x / (radiusX / 2.0);
                        dY = (double)y / (radiusY / 2.0);
                        dZ = (double)z / (radiusZ / 2.0);
                        distance = dX * dX + dY * dY + dZ * dZ;
                        if (!(distance >= 1.0)) continue;
                        boolean nearBurrow = false;
                        for (Direction surroundingDirection : Direction.values()) {
                            double neighborDZ;
                            double neighborDY;
                            double neighborDX = (double)(x + surroundingDirection.getStepX()) / (radiusX / 2.0);
                            if (!(neighborDX * neighborDX + (neighborDY = (double)(y + surroundingDirection.getStepY()) / (radiusY / 2.0)) * neighborDY + (neighborDZ = (double)(z + surroundingDirection.getStepZ()) / (radiusZ / 2.0)) * neighborDZ < 1.0)) continue;
                            nearBurrow = true;
                            break;
                        }
                        if (!nearBurrow) continue;
                        BlockPos currentPos = origin.offset(x, y, z);
                        boolean bl = flag = Math.abs(x) <= 3 && Math.abs(y) <= 3 && Math.abs(z) <= 3;
                        if (!flag) continue;
                        level.setBlock(currentPos, barrierState, 2);
                    }
                }
            }
        }
    }

    private boolean canPlace(WorldGenLevel level, BlockPos origin) {
        int openingCount = 0;
        for (int x = -2; x <= 2; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    boolean isSolid;
                    BlockPos currentPos = origin.offset(x, y, z);
                    boolean bl = isSolid = level.getBlockState(currentPos).isSolid() && level.getBlockState(currentPos).getFluidState().isEmpty();
                    if ((y == -4 || y == 4) && !isSolid || !level.getBlockState(currentPos).getFluidState().isEmpty()) {
                        return false;
                    }
                    if (x != -2 && x != 2 && z != -2 && z != 2 || y != 0 || !level.isEmptyBlock(currentPos) || !level.isEmptyBlock(currentPos.above())) continue;
                    ++openingCount;
                }
            }
        }
        return openingCount >= 1 && openingCount <= 5;
    }

    private boolean canReplaceBlock(BlockState state) {
        return !state.is(BlockTags.FEATURES_CANNOT_REPLACE);
    }

    public record Configuration(List<BlockStateProvider> validBlocks) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(configurationInstance -> configurationInstance.group((App)BlockStateProvider.CODEC.listOf().fieldOf("blocks").orElse(List.of()).forGetter(Configuration::validBlocks)).apply((Applicative)configurationInstance, Configuration::new));
    }
}

