/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.decorator;

import com.farcr.nomansland.common.registry.worldgen.NMLPondDecoratorTypes;
import com.farcr.nomansland.common.world.feature.decorator.PondDecorator;
import com.farcr.nomansland.common.world.feature.decorator.PondDecoratorType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class ClusterOnWaterPondDecorator
extends PondDecorator {
    public static final MapCodec<ClusterOnWaterPondDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(f -> Float.valueOf(f.probability)), (App)Codec.intRange((int)0, (int)16).fieldOf("limit").forGetter(f -> f.limit), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(f -> f.blockProvider)).apply((Applicative)instance, ClusterOnWaterPondDecorator::new));
    protected final float probability;
    protected final int limit;
    protected final BlockStateProvider blockProvider;

    public ClusterOnWaterPondDecorator(float probability, int limit, BlockStateProvider blockProvider) {
        this.probability = probability;
        this.limit = limit;
        this.blockProvider = blockProvider;
    }

    @Override
    protected PondDecoratorType<?> type() {
        return (PondDecoratorType)NMLPondDecoratorTypes.CLUSTER_ON_WATER.get();
    }

    @Override
    public void place(PondDecorator.Context context) {
        HashSet<BlockPos> excluded = new HashSet<BlockPos>();
        int lilies = 0;
        RandomSource random = context.random();
        for (BlockPos pos : Util.shuffledCopy(context.water(), (RandomSource)random)) {
            if (!excluded.contains(pos) && context.isAir(pos.above()) && random.nextFloat() < this.probability) {
                excluded.add(pos.above());
                context.setBlock(pos.above(), this.blockProvider.getState(random, pos.above()));
                ++lilies;
            }
            if (lilies <= this.limit) continue;
            break;
        }
    }
}

