/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.foliageplacer;

import com.farcr.nomansland.common.registry.worldgen.NMLFoliagePlacerTypes;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import org.jetbrains.annotations.NotNull;

public class PineFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<PineFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> PineFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.codec((int)-4, (int)4).fieldOf("offset_increase").forGetter(tree -> tree.offsetIncrease), (App)IntProvider.codec((int)1, (int)8).fieldOf("num_small_canopies").forGetter(tree -> tree.numSmallCanopies), (App)FloatProvider.codec((float)0.0f, (float)1.0f).fieldOf("leaf_probability").forGetter(tree -> tree.leafProbability))).apply((Applicative)instance, PineFoliagePlacer::new));
    private final IntProvider offsetIncrease;
    private final IntProvider numSmallCanopies;
    private final FloatProvider leafProbability;

    public PineFoliagePlacer(IntProvider radius, IntProvider offset, IntProvider offsetIncrease, IntProvider numSmallCanopies, FloatProvider leafProbability) {
        super(radius, offset);
        this.offsetIncrease = offsetIncrease;
        this.numSmallCanopies = numSmallCanopies;
        this.leafProbability = leafProbability;
    }

    @NotNull
    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)NMLFoliagePlacerTypes.PINE_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(@NotNull LevelSimulatedReader level, @NotNull FoliagePlacer.FoliageSetter blockSetter, @NotNull RandomSource random, @NotNull TreeConfiguration config, int maxFreeTreeHeight, @NotNull FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int foliageOffset) {
        Set<BlockPos> layerPositions;
        int i;
        HashSet leafPositions = Sets.newHashSet();
        HashSet probLeafPositions = Sets.newHashSet();
        int numCanopies = (foliageHeight - 5) / 2;
        for (int di = 0; di < 4; ++di) {
            Direction d = Direction.from2DDataValue((int)di);
            leafPositions.add(attachment.pos().below(2).relative(d));
            leafPositions.add(attachment.pos().below(2).relative(d).relative(d.getClockWise()));
            leafPositions.add(attachment.pos().below().relative(d));
            probLeafPositions.add(attachment.pos().below().relative(d).relative(d.getClockWise()));
            leafPositions.add(attachment.pos().relative(d));
        }
        leafPositions.add(attachment.pos());
        leafPositions.add(attachment.pos().above());
        leafPositions.add(attachment.pos().above(2));
        probLeafPositions.add(attachment.pos().above(3));
        int numSmallCanopiesSampled = this.numSmallCanopies.sample(random);
        for (i = 0; i < Math.min(numCanopies, numSmallCanopiesSampled); ++i) {
            layerPositions = this.placeLayer(attachment.pos().below(4 + 2 * i), foliageRadius);
            leafPositions.addAll(layerPositions);
        }
        if (numCanopies >= numSmallCanopiesSampled) {
            for (i = 0; i < numCanopies - numSmallCanopiesSampled; ++i) {
                layerPositions = this.placeLayer(attachment.pos().below(4 + 2 * numSmallCanopiesSampled + 2 * i), foliageRadius + this.offsetIncrease.sample(random));
                leafPositions.addAll(layerPositions);
            }
        }
        leafPositions.add(attachment.pos().below(3 + 2 * numCanopies).north());
        leafPositions.add(attachment.pos().below(3 + 2 * numCanopies).east());
        leafPositions.add(attachment.pos().below(3 + 2 * numCanopies).south());
        leafPositions.add(attachment.pos().below(3 + 2 * numCanopies).west());
        for (BlockPos leafPos : leafPositions) {
            PineFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)leafPos);
        }
        float leafProbabilitySampled = this.leafProbability.sample(random);
        for (BlockPos leafPos : probLeafPositions) {
            if (!(random.nextFloat() > leafProbabilitySampled)) continue;
            PineFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)leafPos);
        }
    }

    private Set<BlockPos> placeLayer(BlockPos localOrigin, int size) {
        HashSet leafPositions = Sets.newHashSet();
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                if (Math.abs(x) + Math.abs(z) < size + 2) {
                    leafPositions.add(localOrigin.offset(x, 0, z));
                }
                if (Math.abs(x) + Math.abs(z) >= size) continue;
                leafPositions.add(localOrigin.offset(x, 1, z));
            }
        }
        return leafPositions;
    }

    public int foliageHeight(@NotNull RandomSource random, int height, @NotNull TreeConfiguration config) {
        return height;
    }

    protected boolean shouldSkipLocation(@NotNull RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return false;
    }
}

