/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.placementmodifier;

import com.farcr.nomansland.common.registry.worldgen.NMLPlacementModifiers;
import com.farcr.nomansland.common.world.densityfunction.LazilyCachedDensityFunctionSeedifier;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class DensityFunctionBasedCountPlacement
extends PlacementModifier {
    public static final MapCodec<DensityFunctionBasedCountPlacement> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("noise_function").forGetter(instance -> instance.densityFunction), (App)Codec.DOUBLE.fieldOf("noise_scale").orElse((Object)1.0).forGetter(instance -> instance.noiseScale), (App)Codec.DOUBLE.fieldOf("noise_minimum").orElse((Object)0.0).forGetter(instance -> instance.noiseMinimum), (App)Codec.DOUBLE.fieldOf("noise_maximum").orElse((Object)1.0).forGetter(instance -> instance.noiseMaximum), (App)Codec.INT.fieldOf("count_minimum").orElse((Object)0).forGetter(instance -> instance.countMinimum), (App)Codec.INT.fieldOf("count_maximum").orElse((Object)8).forGetter(instance -> instance.countMaximum), (App)Codec.BOOL.fieldOf("clamped").orElse((Object)true).forGetter(instance -> instance.clamped)).apply((Applicative)codec, DensityFunctionBasedCountPlacement::new));
    private final DensityFunction densityFunction;
    private final double noiseScale;
    private final double noiseMinimum;
    private final double noiseMaximum;
    private final int countMinimum;
    private final int countMaximum;
    private final boolean clamped;

    public DensityFunctionBasedCountPlacement(DensityFunction densityFunction, double noiseScale, double noiseMinimum, double noiseMaximum, int countMinimum, int countMaximum, boolean clamped) {
        this.densityFunction = densityFunction;
        this.noiseScale = noiseScale;
        this.noiseMinimum = noiseMinimum;
        this.noiseMaximum = noiseMaximum;
        this.countMinimum = countMinimum;
        this.countMaximum = countMaximum;
        this.clamped = clamped;
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        DensityFunction seedifiedDensityFunction = this.densityFunction.mapAll(LazilyCachedDensityFunctionSeedifier.getOrCreate(context.getLevel()));
        double noise = seedifiedDensityFunction.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext((int)((double)pos.getX() * this.noiseScale), (int)((double)pos.getY() * this.noiseScale), (int)((double)pos.getZ() * this.noiseScale)));
        int count = (int)Math.ceil(this.clamped ? Mth.clampedMap((double)noise, (double)this.noiseMinimum, (double)this.noiseMaximum, (double)this.countMinimum, (double)this.countMaximum) : Mth.map((double)noise, (double)this.noiseMinimum, (double)this.noiseMaximum, (double)this.countMinimum, (double)this.countMaximum));
        return IntStream.range(0, count).mapToObj(i -> pos);
    }

    public PlacementModifierType<?> type() {
        return NMLPlacementModifiers.DENSITY_FUNCTION_BASED_COUNT.get();
    }
}

