/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.feature.trunkplacer;

import com.farcr.nomansland.common.registry.worldgen.NMLTrunkPlacerTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

public class CypressTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<CypressTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CypressTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.codec((int)0, (int)5).fieldOf("root_height").forGetter(tree -> tree.rootHeight), (App)IntProvider.codec((int)0, (int)8).fieldOf("branch_count").forGetter(tree -> tree.branchCount), (App)IntProvider.codec((int)1, (int)8).fieldOf("branch_length").forGetter(tree -> tree.branchLength), (App)IntProvider.codec((int)0, (int)8).fieldOf("branch_min_height").forGetter(tree -> tree.branchMinHeight), (App)IntProvider.codec((int)0, (int)8).fieldOf("branch_max_height").forGetter(tree -> tree.branchMaxHeight))).apply((Applicative)instance, CypressTrunkPlacer::new));
    protected final IntProvider rootHeight;
    protected final IntProvider branchCount;
    protected final IntProvider branchLength;
    protected final IntProvider branchMinHeight;
    protected final IntProvider branchMaxHeight;

    public CypressTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, IntProvider rootHeight, IntProvider branchCount, IntProvider branchLength, IntProvider branchMinHeight, IntProvider branchMaxHeight) {
        super(baseHeight, heightRandA, heightRandB);
        this.rootHeight = rootHeight;
        this.branchCount = branchCount;
        this.branchLength = branchLength;
        this.branchMinHeight = branchMinHeight;
        this.branchMaxHeight = branchMaxHeight;
    }

    @MethodsReturnNonnullByDefault
    @NotNull
    protected TrunkPlacerType<?> type() {
        return NMLTrunkPlacerTypes.CYPRESS_TRUNK_PLACER.get();
    }

    @MethodsReturnNonnullByDefault
    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> blockSetter, @NotNull RandomSource random, int freeTreeHeight, @NotNull BlockPos pos, @NotNull TreeConfiguration config) {
        int maxBranchHeight;
        ArrayList<FoliagePlacer.FoliageAttachment> list = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int maxRootHeight = 0;
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                int height = this.rootHeight.sample(random);
                if (height > maxRootHeight) {
                    maxRootHeight = height;
                }
                for (int i = 0; i < height; ++i) {
                    this.placeLog(level, blockSetter, random, pos.offset(x, i, z), config);
                }
            }
        }
        BlockPos trunkPos = maxRootHeight > 0 ? pos.offset(random.nextInt(2), 0, random.nextInt(2)) : pos;
        for (int i = 0; i < freeTreeHeight; ++i) {
            this.placeLog(level, blockSetter, random, trunkPos.above(i), config);
        }
        list.add(new FoliagePlacer.FoliageAttachment(trunkPos.above(freeTreeHeight), 0, false));
        int branches = this.branchCount.sample(random);
        ArrayList<Direction> directions = new ArrayList<Direction>();
        while (directions.size() < branches) {
            Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            if (directions.contains(dir) && directions.size() < 4) continue;
            directions.add(dir);
        }
        int minBranchHeight = this.branchMinHeight.sample(random);
        if (minBranchHeight < freeTreeHeight - (maxBranchHeight = this.branchMaxHeight.sample(random))) {
            for (Direction dir : directions) {
                int height = random.nextIntBetweenInclusive(minBranchHeight, freeTreeHeight - maxBranchHeight);
                BlockPos foliagePos = this.makeLimb(level, blockSetter, random, trunkPos.above(height), this.branchLength.sample(random), dir, config);
                list.add(new FoliagePlacer.FoliageAttachment(foliagePos, 0, false));
            }
        }
        return list;
    }

    private BlockPos makeLimb(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos basePos, int steps, Direction dir, TreeConfiguration config) {
        int wobble = random.nextInt(3) - 1;
        int wobbleStart = random.nextInt(steps);
        Function<BlockState, BlockState> function = log -> (BlockState)log.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis());
        for (int i = 0; i < steps; ++i) {
            BlockPos currentBlockPos = i >= wobbleStart ? basePos.relative(dir, i + 1).relative(dir.getClockWise(), wobble) : basePos.relative(dir, i + 1);
            this.placeLog(level, blockSetter, random, currentBlockPos, config, function);
        }
        return basePos.relative(dir, steps).relative(dir.getClockWise(), wobble).above();
    }
}

