/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.structure.processor;

import com.farcr.nomansland.common.registry.worldgen.NMLStructureProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BlockRemoverProcessor
extends StructureProcessor {
    public static final MapCodec<BlockRemoverProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(prefixProcessor -> prefixProcessor.block), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(prefixProcessor -> Float.valueOf(prefixProcessor.chance))).apply((Applicative)instance, BlockRemoverProcessor::new));
    private final float chance;
    private final Block block;

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)NMLStructureProcessorTypes.BLOCK_REMOVER.get();
    }

    public BlockRemoverProcessor(Block block, float chance) {
        this.block = block;
        this.chance = chance;
    }

    public List<StructureTemplate.StructureBlockInfo> finalizeProcessing(ServerLevelAccessor serverLevel, BlockPos offset, BlockPos pos, List<StructureTemplate.StructureBlockInfo> originalBlockInfos, List<StructureTemplate.StructureBlockInfo> processedBlockInfos, StructurePlaceSettings settings) {
        ArrayList<StructureTemplate.StructureBlockInfo> finalBlockInfos = new ArrayList<StructureTemplate.StructureBlockInfo>(List.copyOf(processedBlockInfos));
        if (settings.getRandom(pos).nextFloat() < this.chance) {
            for (StructureTemplate.StructureBlockInfo blockInfo : processedBlockInfos) {
                if (this.block == Blocks.WATER && blockInfo.state().hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    finalBlockInfos.remove(blockInfo);
                    finalBlockInfos.add(new StructureTemplate.StructureBlockInfo(blockInfo.pos(), (BlockState)blockInfo.state().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), blockInfo.nbt()));
                }
                if (!blockInfo.state().is(this.block)) continue;
                finalBlockInfos.remove(blockInfo);
                finalBlockInfos.add(new StructureTemplate.StructureBlockInfo(blockInfo.pos(), Blocks.AIR.defaultBlockState(), blockInfo.nbt()));
            }
        }
        return finalBlockInfos;
    }
}

