/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.surfacerule;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;

public record BiomeTagConditionSource(List<TagKey<Biome>> biomeTags) implements SurfaceRules.ConditionSource
{
    public static final KeyDispatchDataCodec<BiomeTagConditionSource> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(record -> record.group((App)TagKey.codec((ResourceKey)Registries.BIOME).listOf().fieldOf("is_biome_tags").forGetter(BiomeTagConditionSource::biomeTags)).apply((Applicative)record, BiomeTagConditionSource::new)));

    public BiomeTagConditionSource(TagKey<Biome> ... biomeTags) {
        this(List.of(biomeTags));
    }

    public KeyDispatchDataCodec<? extends SurfaceRules.ConditionSource> codec() {
        return CODEC;
    }

    public SurfaceRules.Condition apply(final SurfaceRules.Context p_context) {
        class BiomeCondition
        extends SurfaceRules.LazyYCondition {
            BiomeCondition() {
                super(context);
            }

            protected boolean compute() {
                Holder biome = (Holder)this.context.biome.get();
                for (TagKey<Biome> biomeTag : BiomeTagConditionSource.this.biomeTags()) {
                    if (!biome.is(biomeTag)) continue;
                    return true;
                }
                return false;
            }
        }
        return new BiomeCondition();
    }

    @Override
    public String toString() {
        return "BiomeConditionSource[biomesTags=" + String.valueOf(this.biomeTags) + "]";
    }
}

