/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.surfacerule;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.jetbrains.annotations.Nullable;

public record StrataRuleSource(List<BlockState> strataEntries, boolean jumbleEntries) implements SurfaceRules.RuleSource
{
    public static final KeyDispatchDataCodec<StrataRuleSource> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(record -> record.group((App)BlockState.CODEC.listOf().fieldOf("strata_entries").forGetter(StrataRuleSource::strataEntries), (App)Codec.BOOL.fieldOf("jumble_entries").forGetter(StrataRuleSource::jumbleEntries)).apply((Applicative)record, StrataRuleSource::new)));

    public StrataRuleSource(boolean jumbleEntries, BlockState ... strataEntries) {
        this(List.of(strataEntries), jumbleEntries);
    }

    public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> codec() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        return this.jumbleEntries ? new JumbledStrataRule(context, this.strataEntries) : new StrataRule(context, this.strataEntries);
    }

    private static int lowBiasHash(int num) {
        num ^= num >> 16;
        num *= 2146121005;
        num ^= num >> 15;
        num *= -2073254261;
        num ^= num >> 16;
        return num;
    }

    private record JumbledStrataRule(SurfaceRules.Context context, List<BlockState> strataEntries) implements SurfaceRules.SurfaceRule
    {
        @Nullable
        public BlockState tryApply(int x, int y, int z) {
            int offset = (int)Math.round(this.context.system.clayBandsOffsetNoise.getValue((double)x, 0.0, (double)z) * 4.0);
            int index = Math.floorMod(StrataRuleSource.lowBiasHash(y + offset), this.strataEntries.size());
            return this.strataEntries.get(index);
        }
    }

    private record StrataRule(SurfaceRules.Context context, List<BlockState> strataEntries) implements SurfaceRules.SurfaceRule
    {
        @Nullable
        public BlockState tryApply(int x, int y, int z) {
            int offset = (int)Math.round(this.context.system.clayBandsOffsetNoise.getValue((double)x, 0.0, (double)z) * 4.0);
            int index = Math.floorMod(y + offset, this.strataEntries.size());
            return this.strataEntries.get(index);
        }
    }
}

