/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.datagen;

import com.farcr.nomansland.common.definitions.BlockDefinition;
import com.farcr.nomansland.common.definitions.ItemDefinition;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.items.NMLItems;
import com.farcr.nomansland.common.registry.worldgen.NMLBiomes;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class NMLLanguageProvider
extends LanguageProvider {
    public NMLLanguageProvider(PackOutput output) {
        super(output, "nomansland", "en_us");
    }

    protected void addTranslations() {
        for (BlockDefinition<?> blockDefinition : NMLBlocks.BLOCK_DEFINITIONS) {
            if (blockDefinition.hasCustomLang()) continue;
            this.add(blockDefinition.langKey(), blockDefinition.langName());
        }
        for (ItemDefinition itemDefinition : NMLItems.ITEM_DEFINITIONS) {
            if (itemDefinition.hasCustomLang() || itemDefinition.isBlockItem()) continue;
            this.add(itemDefinition.langKey(), itemDefinition.langName());
        }
        for (ResourceKey resourceKey : NMLBiomes.BIOMES) {
            this.add(NMLBiomes.langKey((ResourceKey<Biome>)resourceKey), NMLBiomes.langName((ResourceKey<Biome>)resourceKey));
        }
        this.add("item.nomansland.billhook_bass_bucket", "Bucket of Billhook Bass");
        this.add("item.nomansland.billhook_bass", "Raw Billhook Bass");
        this.add("item.nomansland.no_mans_globe", "No Man's Globe");
        this.add("item.nomansland.maple_chest_boat", "Maple Boat with Chest");
        this.add("item.nomansland.pine_chest_boat", "Pine Boat with Chest");
        this.add("item.nomansland.walnut_chest_boat", "Walnut Boat with Chest");
        this.add("item.nomansland.willow_chest_boat", "Willow Boat with Chest");
        this.add("item.nomansland.maple_furnace_boat", "Maple Boat with Furnace");
        this.add("item.nomansland.pine_furnace_boat", "Pine Boat with Furnace");
        this.add("item.nomansland.walnut_furnace_boat", "Walnut Boat with Furnace");
        this.add("item.nomansland.willow_furnace_boat", "Willow Boat with Furnace");
        this.add("itemGroup.nomansland", "No Man's Land");
        this.add("entity.nomansland.buried", "Buried");
        this.add("entity.nomansland.cave_carp", "Cave Carp");
        this.add("entity.nomansland.billhook_bass", "Billhook Bass");
        this.add("entity.nomansland.deer", "Deer");
        this.add("entity.nomansland.tortoise", "Tortoise");
        this.add("entity.nomansland.goose", "Goose");
        this.add("fluid_type.nomansland.resin_oil", "Resin Oil");
        this.add("nomansland.tooltip.mask.regeneration", "Slowly regenerates health");
        this.add("nomansland.subtitles.block.spike_trap.extend", "Spikes extend");
        this.add("nomansland.subtitles.block.spike_trap.retract", "Spikes retract");
        this.add("nomansland.subtitles.block.monster_anchor.monster_resurrection", "Monster begins resurrection");
        this.add("nomansland.subtitles.block.monster_anchor.monster_spawns", "Monster spawns");
        this.add("nomansland.subtitles.block.monster_anchor.activate", "Monster anchor activates");
        this.add("nomansland.subtitles.block.monster_anchor.deactivate", "Monster anchor deactivates");
        this.add("nomansland.subtitles.torch.extinguish", "Torch extinguishes");
        this.add("nomansland.subtitles.torch.light", "Torch lights");
        this.add("nomansland.subtitles.block.witch_stew_cauldron.ambient", "Witch Stew Cauldron gurgles");
        this.add("nomansland.subtitles.block.witch_stew_cauldron.clean", "Witch Stew Cauldron is cleaned");
        this.add("nomansland.subtitles.block.witch_stew_cauldron.empty", "Witch Stew pours into bowl");
        this.add("effect.nomansland.pacified", "Pacified");
        this.add("entity.nomansland.ink_cloud", "Ink Cloud");
        this.add("nomansland.subtitles.entity.player.drink_milk", "Player drinks milk");
        this.add("nomansland.subtitles.entity.generic.sticky_cauldron_slide", "Sliding in a sticky cauldron");
        this.add("nomansland.subtitles.item.generic.consumed", "Item consumed");
        this.add("nomansland.subtitles.item.bomb.primed", "Bomb primed");
        this.add("nomansland.subtitles.entity.billhook_bass.death", "Billhook Bass dies");
        this.add("nomansland.subtitles.entity.billhook_bass.flop", "Billhook Bass flops");
        this.add("nomansland.subtitles.entity.billhook_bass.hurt", "Billhook Bass hurts");
        this.add("nomansland.subtitles.entity.deer.death", "Deer dies");
        this.add("nomansland.subtitles.entity.deer.hurt", "Deer hurts");
        this.add("nomansland.subtitles.entity.deer.ambient", "Deer bleats");
        this.add("nomansland.subtitles.entity.goose.death", "Goose dies");
        this.add("nomansland.subtitles.entity.goose.hurt", "Goose hurts");
        this.add("nomansland.subtitles.entity.goose.ambient", "Goose honks");
        this.add("nomansland.subtitles.particle.droplet.fall", "Droplet falls");
        this.add("nomansland.subtitles.entity.living_urn.shatter", "Living Urn shatters");
        this.add("death.attack.nomansland.icicle_pierce", "%1$s was pierced by an icicle");
        this.add("death.attack.nomansland.icicle_pierce.player", "%1$s was pierced by an icicle while fighting %2$s");
        this.add("death.attack.nomansland.spike_fall", "%1$s fell for a spike trap");
        this.add("death.attack.nomansland.spike_fall.player", "%1$s fell for a spike trap while fighting %2$s");
        this.add("death.attack.nomansland.spike_impale", "%1$s was impaled in a spike trap");
        this.add("death.attack.nomansland.spike_impale.player", "%1$s was impaled in a spike trap while fighting %2$s");
        this.add("death.attack.nomansland.spike_poke", "%1$s got stuck in a spike trap");
        this.add("death.attack.nomansland.spike_poke.player", "%1$s got stuck in a spike trap while fighting %2$s");
        this.add("death.attack.nomansland.spike_skewer", "%1$s was skewered by a spike trap");
        this.add("death.attack.nomansland.spike_skewer.player", "%1$s was skewered by a spike trap while fighting %2$s");
        this.add("death.attack.nomansland.combust", "%1$s faced immolation");
        this.add("death.attack.nomansland.combust.player", "%1$s was immolated by %2$s");
        this.add("entity.nomansland.explosive", "Explosive");
        this.add("entity.nomansland.firebomb", "Firebomb");
        this.add("effect.nomansland.flammable", "Flammable");
        this.add("nomansland.advancements.use_tap.title", "Tree Juice");
        this.add("nomansland.advancements.use_tap.description", "Collect Resin or Maple Syrup with a Tap and a Cauldron");
        this.add("nomansland.advancements.kill_anchored_mob.title", "Can't Even Die Right");
        this.add("nomansland.advancements.kill_anchored_mob.description", "Defeat an enemy under the influence of a Monster Anchor");
        this.add("nomansland.advancements.when_pigs_fly.title", "When Pigs Fly");
        this.add("nomansland.advancements.when_pigs_fly.description", "Ride a pig down a 40 block fall without it taking damage");
        this.add("nomansland.advancements.ignite_flammable_enemy.title", "Grossly Incandescent");
        this.add("nomansland.advancements.ignite_flammable_enemy.description", "Set an enemy on fire after dousing it in Resin Oil");
        this.add("nomansland.advancements.explode_ore.title", "Gets The Job Done");
        this.add("nomansland.advancements.explode_ore.description", "Mine Ores with an Explosive instead of a Pickaxe");
        this.add("nomansland.advancements.find_ancient_city.title", "Blue Hum");
        this.add("nomansland.advancements.find_ancient_city.description", "Find an Ancient City");
        this.add("nomansland.advancements.find_mineshaft.title", "To Blisters and Bedrock");
        this.add("nomansland.advancements.find_mineshaft.description", "Find a Mineshaft");
        this.add("block.nomansland.resin_cauldron", "Cauldron Filled with Resin");
        this.add("block.nomansland.honey_cauldron", "Cauldron Filled with Honey");
        this.add("block.nomansland.maple_syrup_cauldron", "Cauldron Filled with Maple Syrup");
        this.add("block.nomansland.resin_oil_cauldron", "Cauldron Filled with Resin Oil");
        this.add("block.nomansland.milk_cauldron", "Cauldron Filled with Milk");
        this.add("block_type.nomansland.trimmed_planks", "Trimmed %s Planks");
        this.add("block_type.nomansland.bookshelf", "%s Bookshelf");
        this.add("design.nomansland.tortoise.sandy", "Sandy");
        this.add("design.nomansland.tortoise.green", "Green");
        this.add("design.nomansland.tortoise.gray", "Gray");
    }
}

