/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.datagen.tags;

import com.farcr.nomansland.NoMansLand;
import com.farcr.nomansland.common.block.cauldrons.FourLayeredCauldronBlock;
import com.farcr.nomansland.common.block.cauldrons.WitchStewCauldron;
import com.farcr.nomansland.common.definitions.BlockDefinition;
import com.farcr.nomansland.common.integration.BlueprintIntegration;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class NMLBlockTagsProvider
extends BlockTagsProvider {
    public NMLBlockTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "nomansland", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (BlockDefinition<?> definition : NMLBlocks.BLOCK_DEFINITIONS) {
            if (definition.get() instanceof FlowerBlock) {
                this.tag(BlockTags.SMALL_FLOWERS).add((Object)definition.block());
            }
            if (definition.get() instanceof WallBlock) {
                this.tag(BlockTags.WALLS).add((Object)definition.block());
            }
            if (definition.get() instanceof SaplingBlock) {
                this.tag(BlockTags.SAPLINGS).add((Object)definition.block());
            }
            if (definition.get() instanceof FourLayeredCauldronBlock && !(definition.get() instanceof WitchStewCauldron)) {
                this.tag(BlockTags.CAULDRONS).add((Object)definition.block());
            }
            if (definition.get() instanceof TorchBlock && !(definition.get() instanceof WallTorchBlock)) {
                this.tag(BlockTags.WALL_POST_OVERRIDE).add((Object)definition.block());
            }
            if (definition.get() instanceof LeavesBlock) {
                this.tag(BlockTags.LEAVES).add((Object)definition.block());
            }
            if (definition.get() instanceof SlabBlock) {
                this.tag(BlockTags.SLABS).add((Object)definition.block());
            }
            if (!(definition.get() instanceof StairBlock)) continue;
            this.tag(BlockTags.STAIRS).add((Object)definition.block());
        }
        this.tag(BlockTags.CAULDRONS).addOptional(NoMansLand.location("pot_of_witch_stew"));
        for (NMLBlocks.Woodset woodset : NMLBlocks.WOODSETS) {
            this.tag(BlockTags.STANDING_SIGNS).add((Object)woodset.sign().block());
            this.tag(BlockTags.WALL_SIGNS).add((Object)woodset.wallSign().block());
            this.tag(BlockTags.CEILING_HANGING_SIGNS).add((Object)woodset.hangingSign().block());
            this.tag(BlockTags.WALL_HANGING_SIGNS).add((Object)woodset.hangingWallSign().block());
            this.tag(BlockTags.PLANKS).add((Object)woodset.planks().block());
            this.tag(NMLTags.BOOKSHELVES.blockTag()).add((Object)woodset.bookshelf().block());
            this.tag(Tags.Blocks.FENCE_GATES_WOODEN).add((Object)woodset.fenceGate().block());
            this.tag(BlockTags.FENCE_GATES).add((Object)woodset.fenceGate().block());
            this.tag(Tags.Blocks.FENCES_WOODEN).add((Object)woodset.fence().block());
            this.tag(BlockTags.WOODEN_FENCES).add((Object)woodset.fence().block());
            this.tag(BlockTags.WOODEN_STAIRS).add((Object)woodset.stairs().block());
            this.tag(BlockTags.WOODEN_BUTTONS).add((Object)woodset.button().block());
            this.tag(BlockTags.WOODEN_DOORS).add((Object)woodset.door().block());
            this.tag(BlockTags.WOODEN_SLABS).add((Object)woodset.slab().block());
            this.tag(BlockTags.WOODEN_PRESSURE_PLATES).add((Object)woodset.pressurePlate().block());
            this.tag(BlockTags.WOODEN_TRAPDOORS).add((Object)woodset.trapdoor().block());
            this.tag(BlockTags.LOGS).add((Object)woodset.log().block());
            this.tag(Tags.Blocks.STRIPPED_LOGS).add((Object)woodset.strippedLog().block());
            this.tag(Tags.Blocks.STRIPPED_WOODS).add((Object)woodset.strippedWood().block());
        }
        this.tag(NMLTags.BOOKSHELVES.blockTag()).add((Object[])new Block[]{NMLBlocks.ACACIA_BOOKSHELF.block(), NMLBlocks.BAMBOO_BOOKSHELF.block(), NMLBlocks.BIRCH_BOOKSHELF.block(), NMLBlocks.CHERRY_BOOKSHELF.block(), NMLBlocks.CRIMSON_BOOKSHELF.block(), NMLBlocks.DARK_OAK_BOOKSHELF.block(), NMLBlocks.JUNGLE_BOOKSHELF.block(), NMLBlocks.MANGROVE_BOOKSHELF.block(), NMLBlocks.SPRUCE_BOOKSHELF.block(), NMLBlocks.WARPED_BOOKSHELF.block()});
        this.addToTags(NMLTags.BOOKSHELVES.blockTag(), Tags.Blocks.BOOKSHELVES, BlockTags.ENCHANTMENT_POWER_PROVIDER, BlueprintIntegration.woodenBookshelves().blockTag());
        this.tag(BlockTags.PLANKS).addTag(NMLTags.TRIMMED_PLANKS.blockTag());
        this.tag(BlockTags.LOGS_THAT_BURN).addTags(new TagKey[]{NMLTags.MAPLE_LOGS.blockTag(), NMLTags.PINE_LOGS.blockTag(), NMLTags.WALNUT_LOGS.blockTag(), NMLTags.WILLOW_LOGS.blockTag()});
        this.tag(BlockTags.OVERWORLD_NATURAL_LOGS).add((Object[])new Block[]{NMLBlocks.MAPLE.log().block(), NMLBlocks.PINE.log().block(), NMLBlocks.WALNUT.log().block(), NMLBlocks.WILLOW.log().block()});
        this.addToTags(NMLBlocks.SILT.block(), BlockTags.OVERWORLD_CARVER_REPLACEABLES, BlockTags.LUSH_GROUND_REPLACEABLE, BlockTags.MOSS_REPLACEABLE, BlockTags.SCULK_REPLACEABLE, BlockTags.CONVERTABLE_TO_MUD, BlockTags.DEAD_BUSH_MAY_PLACE_ON, BlockTags.BIG_DRIPLEAF_PLACEABLE, BlockTags.BAMBOO_PLANTABLE_ON);
        this.addToTags((Block)NMLBlocks.CUT_VINE.get(), BlockTags.MANGROVE_LOGS_CAN_GROW_THROUGH, BlockTags.MANGROVE_ROOTS_CAN_GROW_THROUGH);
        this.addToTags((Block)NMLBlocks.SEASHELLS.get(), BlockTags.COMBINATION_STEP_SOUND_BLOCKS);
    }

    @SafeVarargs
    protected final void addToTags(Block block, TagKey<Block> ... blockTags) {
        List.of(blockTags).forEach(blockTag -> this.tag((TagKey)blockTag).add((Object)block));
    }

    @SafeVarargs
    protected final void addToTags(TagKey<Block> block, TagKey<Block> ... blockTags) {
        List.of(blockTags).forEach(blockTag -> this.tag((TagKey)blockTag).addTag(block));
    }
}

