/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.gildedblackstoneblocks.block;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.petemc.gildedblackstoneblocks.item.ModItems;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"gildedblackstoneblocks");
    public static final DeferredBlock<Block> GILDED_BLACKSTONE_STAIRS = ModBlocks.registerBlock("gilded_blackstone_stairs", () -> new StairBlock(Blocks.GILDED_BLACKSTONE.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GILDED_BLACKSTONE).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> GILDED_BLACKSTONE_SLAB = ModBlocks.registerBlock("gilded_blackstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GILDED_BLACKSTONE).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> GILDED_BLACKSTONE_WALL = ModBlocks.registerBlock("gilded_blackstone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GILDED_BLACKSTONE).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> GILDED_BLACKSTONE_BUTTON = ModBlocks.registerBlock("gilded_blackstone_button", () -> new ButtonBlock(BlockSetType.STONE, 10, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GILDED_BLACKSTONE).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> GILDED_BLACKSTONE_PLATE = ModBlocks.registerBlock("gilded_blackstone_pressure_plate", () -> new PressurePlateBlock(new BlockSetType("gilded_blackstone", true, true, false, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.GILDED_BLACKSTONE, SoundEvents.NETHER_WOOD_DOOR_CLOSE, SoundEvents.NETHER_WOOD_DOOR_OPEN, SoundEvents.NETHER_WOOD_TRAPDOOR_CLOSE, SoundEvents.NETHER_WOOD_TRAPDOOR_OPEN, SoundEvents.STONE_PRESSURE_PLATE_CLICK_OFF, SoundEvents.STONE_PRESSURE_PLATE_CLICK_ON, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundEvents.STONE_BUTTON_CLICK_ON), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GILDED_BLACKSTONE).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> POLISHED_GILDED_BLACKSTONE = ModBlocks.registerBlock("polished_gilded_blackstone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_BLACKSTONE).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> POLISHED_GILDED_BLACKSTONE_STAIRS = ModBlocks.registerBlock("polished_gilded_blackstone_stairs", () -> new StairBlock(((Block)POLISHED_GILDED_BLACKSTONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_BLACKSTONE_STAIRS).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> POLISHED_GILDED_BLACKSTONE_SLAB = ModBlocks.registerBlock("polished_gilded_blackstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_BLACKSTONE_SLAB).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> POLISHED_GILDED_BLACKSTONE_WALL = ModBlocks.registerBlock("polished_gilded_blackstone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_BLACKSTONE_WALL).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> POLISHED_GILDED_BLACKSTONE_BUTTON = ModBlocks.registerBlock("polished_gilded_blackstone_button", () -> new ButtonBlock(BlockSetType.STONE, 10, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BUTTON).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> POLISHED_GILDED_BLACKSTONE_PLATE = ModBlocks.registerBlock("polished_gilded_blackstone_pressure_plate", () -> new PressurePlateBlock(new BlockSetType("polished_gilded_blackstone", true, true, false, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.GILDED_BLACKSTONE, SoundEvents.NETHER_WOOD_DOOR_CLOSE, SoundEvents.NETHER_WOOD_DOOR_OPEN, SoundEvents.NETHER_WOOD_TRAPDOOR_CLOSE, SoundEvents.NETHER_WOOD_TRAPDOOR_OPEN, SoundEvents.STONE_PRESSURE_PLATE_CLICK_OFF, SoundEvents.STONE_PRESSURE_PLATE_CLICK_ON, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundEvents.STONE_BUTTON_CLICK_ON), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_BLACKSTONE_PRESSURE_PLATE).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> CHISELED_POLISHED_GILDED_BLACKSTONE = ModBlocks.registerBlock("chiseled_polished_gilded_blackstone", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHISELED_POLISHED_BLACKSTONE).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> GILDED_BLACKSTONE_BRICKS = ModBlocks.registerBlock("gilded_blackstone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_BLACKSTONE_BRICKS).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> GILDED_BLACKSTONE_BRICK_STAIRS = ModBlocks.registerBlock("gilded_blackstone_brick_stairs", () -> new StairBlock(((Block)GILDED_BLACKSTONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_BLACKSTONE_BRICK_STAIRS).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> GILDED_BLACKSTONE_BRICK_SLAB = ModBlocks.registerBlock("gilded_blackstone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_BLACKSTONE_BRICK_SLAB).sound(SoundType.GILDED_BLACKSTONE)));
    public static final DeferredBlock<Block> GILDED_BLACKSTONE_BRICK_WALL = ModBlocks.registerBlock("gilded_blackstone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POLISHED_BLACKSTONE_BRICK_WALL).sound(SoundType.GILDED_BLACKSTONE)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

