/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import me.fami6xx.blockywhitelist.BlockyWhitelist;

public class JSONStore {
    private transient Gson gson;
    private transient File file;
    public List<String> allowedRoles = new ArrayList<String>();
    public List<String> addedRoles = new ArrayList<String>();
    public String botToken = "";
    public String guildId = "";
    public HashMap<UUID, String> linkedPlayers = new HashMap();
    public HashMap<String, UUID> pendingPlayers = new HashMap();
    public String failedRoleIdOne = "";
    public String failedRoleIdTwo = "";
    public String failedRoleIdThree = "";

    public JSONStore(File file) {
        this.file = file;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    private void setData(File file, Gson gson) {
        this.file = file;
        this.gson = gson;
    }

    @Nullable
    public synchronized UUID getLinkedPlayer(String discordId) {
        for (UUID uuid : this.linkedPlayers.keySet()) {
            if (!this.linkedPlayers.get(uuid).equals(discordId)) continue;
            return uuid;
        }
        return null;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            this.gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            BlockyWhitelist.getInstance().getLogger().severe("Failed to save JSON data to " + this.file.getName());
            BlockyWhitelist.getInstance().getLogger().severe(e.getMessage());
        }
    }

    public static JSONStore load(File file) {
        JSONStore jSONStore;
        if (!file.exists()) {
            return new JSONStore(file);
        }
        FileReader reader = new FileReader(file);
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JSONStore json = (JSONStore)gson.fromJson((Reader)reader, JSONStore.class);
            json.setData(file, gson);
            jSONStore = json;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                BlockyWhitelist.getInstance().getLogger().severe("Failed to load JSON data from " + file.getName());
                BlockyWhitelist.getInstance().getLogger().severe(e.getMessage());
                return null;
            }
        }
        ((Reader)reader).close();
        return jSONStore;
    }
}

