/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist.menus;

import me.fami6xx.blockywhitelist.BlockyWhitelist;
import me.fami6xx.blockywhitelist.utils.FamiUtils;
import me.fami6xx.blockywhitelist.utils.menus.PlayerMenu;
import me.fami6xx.blockywhitelist.utils.menus.types.EasyPaginatedMenu;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Role;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class ChooseRoleMenu
extends EasyPaginatedMenu {
    private final Guild guild;
    private final BlockyWhitelist blockyWhitelist = BlockyWhitelist.getInstance();

    public ChooseRoleMenu(PlayerMenu menu) {
        super(menu);
        this.guild = this.blockyWhitelist.getGuild();
    }

    @Override
    public String getMenuName() {
        return FamiUtils.format("&b&lBW &cSelect a role");
    }

    @Override
    public ItemStack getItemFromIndex(int index) {
        Role role = (Role)this.guild.getRoles().get(index);
        ItemStack item = this.isAlreadySelected(role) ? FamiUtils.makeItem(Material.EMERALD_BLOCK, FamiUtils.format("&b" + role.getName()), "&7Already selected") : FamiUtils.makeItem(Material.EMERALD, FamiUtils.format("&b" + role.getName()), "&7Click to select");
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.blockyWhitelist, "role");
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)role.getId());
        item.setItemMeta(meta);
        if (this.isAlreadySelected(role)) {
            return FamiUtils.addGlow(item);
        }
        return item;
    }

    @Override
    public int getCollectionSize() {
        return this.guild.getRoles().size();
    }

    @Override
    public void handlePaginatedMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta().getPersistentDataContainer().isEmpty()) {
            return;
        }
        if (e.getCurrentItem().getItemMeta().hasEnchant(Enchantment.ARROW_INFINITE)) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.blockyWhitelist, "role");
        String roleId = (String)e.getCurrentItem().getItemMeta().getPersistentDataContainer().get(key, PersistentDataType.STRING);
        if (roleId == null) {
            return;
        }
        Role role = this.guild.getRoleById(roleId);
        if (role == null) {
            return;
        }
        this.handleRoleSelection(role);
    }

    @Override
    public void addAdditionalItems() {
    }

    public abstract void handleRoleSelection(Role var1);

    public abstract boolean isAlreadySelected(Role var1);
}

