/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist.menus;

import java.util.HashMap;
import java.util.UUID;
import me.fami6xx.blockywhitelist.BlockyWhitelist;
import me.fami6xx.blockywhitelist.utils.FamiUtils;
import me.fami6xx.blockywhitelist.utils.menus.PlayerMenu;
import me.fami6xx.blockywhitelist.utils.menus.types.EasyPaginatedMenu;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class LinkedUsersMenu
extends EasyPaginatedMenu {
    private final HashMap<UUID, String> linkedPlayers;
    private final UUID[] linkedPlayersKeys;
    private final NamespacedKey key;

    public LinkedUsersMenu(PlayerMenu menu) {
        super(menu);
        BlockyWhitelist plugin = BlockyWhitelist.getInstance();
        this.linkedPlayers = (HashMap)plugin.getJsonStore().linkedPlayers.clone();
        this.linkedPlayersKeys = this.linkedPlayers.keySet().toArray(new UUID[0]);
        this.key = new NamespacedKey((Plugin)plugin, "linked");
    }

    @Override
    public ItemStack getItemFromIndex(int index) {
        UUID uuid = this.linkedPlayersKeys[index];
        String discordId = this.linkedPlayers.get(uuid);
        OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)uuid);
        ItemStack item = FamiUtils.makeSkullItem(p, "&b" + p.getName(), "&7Discord ID: &c" + discordId, "&7Click to unlink");
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        meta.getPersistentDataContainer().set(this.key, PersistentDataType.STRING, (Object)uuid.toString());
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public int getCollectionSize() {
        return this.linkedPlayersKeys.length;
    }

    @Override
    public void handlePaginatedMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta().getPersistentDataContainer().has(this.key, PersistentDataType.STRING)) {
            UUID uuid = UUID.fromString((String)e.getCurrentItem().getItemMeta().getPersistentDataContainer().get(this.key, PersistentDataType.STRING));
            BlockyWhitelist.getInstance().getJsonStore().linkedPlayers.remove(uuid);
            BlockyWhitelist.getInstance().getJsonStore().save();
            LinkedUsersMenu menu = new LinkedUsersMenu(this.playerMenu);
            menu.open();
        }
    }

    @Override
    public void addAdditionalItems() {
    }

    @Override
    public String getMenuName() {
        return FamiUtils.formatWithPrefix("&cLinked Users");
    }
}

