/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist.menus;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.fami6xx.blockywhitelist.BlockyWhitelist;
import me.fami6xx.blockywhitelist.utils.FamiUtils;
import me.fami6xx.blockywhitelist.utils.menus.PlayerMenu;
import me.fami6xx.blockywhitelist.utils.menus.types.EasyPaginatedMenu;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PendingUsersMenu
extends EasyPaginatedMenu {
    private final UUID[] pendingPlayers;
    private final NamespacedKey key;
    private final Set<Map.Entry<String, UUID>> pendingPlayersEntrySet;

    public PendingUsersMenu(PlayerMenu menu) {
        super(menu);
        BlockyWhitelist plugin = BlockyWhitelist.getInstance();
        this.pendingPlayers = plugin.getJsonStore().pendingPlayers.values().toArray(new UUID[0]);
        this.pendingPlayersEntrySet = plugin.getJsonStore().pendingPlayers.entrySet();
        this.key = new NamespacedKey((Plugin)plugin, "pending");
    }

    @Override
    public ItemStack getItemFromIndex(int index) {
        UUID uuid = this.pendingPlayers[index];
        String linkKey = (String)this.pendingPlayersEntrySet.stream().filter(entry -> ((UUID)entry.getValue()).toString().equals(uuid.toString())).findFirst().get().getKey();
        OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)uuid);
        ItemStack item = FamiUtils.makeSkullItem(p, "&b" + p.getName(), "&7Link key: &c" + linkKey, "&7Click to remove");
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        meta.getPersistentDataContainer().set(this.key, PersistentDataType.STRING, (Object)linkKey);
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public int getCollectionSize() {
        return this.pendingPlayers.length;
    }

    @Override
    public void handlePaginatedMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (e.getCurrentItem().getItemMeta().getPersistentDataContainer().has(this.key, PersistentDataType.STRING)) {
            String linkKey = (String)e.getCurrentItem().getItemMeta().getPersistentDataContainer().get(this.key, PersistentDataType.STRING);
            BlockyWhitelist.getInstance().getJsonStore().pendingPlayers.remove(linkKey);
            BlockyWhitelist.getInstance().getJsonStore().save();
            PendingUsersMenu menu = new PendingUsersMenu(this.playerMenu);
            menu.open();
        }
    }

    @Override
    public void addAdditionalItems() {
    }

    @Override
    public String getMenuName() {
        return FamiUtils.formatWithPrefix("&cPending Users");
    }
}

