/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.fami6xx.blockywhitelist.BlockyWhitelist;
import me.fami6xx.blockywhitelist.utils.languages.Lang;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.data.type.Door;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FamiUtils {
    public static String format(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String formatWithPrefix(String message) {
        return FamiUtils.format(Lang.prefix + message);
    }

    public static String replace(String message, HashMap<String, String> replace) {
        for (String key : replace.keySet()) {
            message = message.replace(key, replace.get(key));
        }
        return message;
    }

    public static String replaceAndFormat(String message, HashMap<String, String> replace) {
        return FamiUtils.format(FamiUtils.replace(message, replace));
    }

    public static void sendMessageWithPrefix(Player player, String message) {
        player.sendMessage(FamiUtils.formatWithPrefix(message));
    }

    public static void sendMessageWithPrefix(Player player, String message, HashMap<String, String> replace) {
        player.sendMessage(FamiUtils.formatWithPrefix(FamiUtils.replace(message, replace)));
    }

    public static void sendMessageInRange(Player player, String message, int range) {
        String finalMessage = FamiUtils.format(message);
        FamiUtils.sendMessageInRangeSynchronized(player, range, finalMessage);
    }

    public static void sendMessageInRange(Player player, String message, int range, HashMap<String, String> replace) {
        String finalMessage = FamiUtils.format(FamiUtils.replace(message, replace));
        FamiUtils.sendMessageInRangeSynchronized(player, range, finalMessage);
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NullPointerException | NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static void sendMessageInRangeSynchronized(final Player player, final int range, final String finalMessage) {
        player.sendMessage(finalMessage);
        new BukkitRunnable(){

            public void run() {
                player.getNearbyEntities((double)range, (double)range, (double)range).stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).forEach(player1 -> player1.sendMessage(finalMessage));
            }
        }.runTask((Plugin)BlockyWhitelist.getInstance());
    }

    public static void sendMessage(Player player, String message) {
        player.sendMessage(FamiUtils.format(message));
    }

    public static ItemStack makeItem(Material material, String displayName, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(FamiUtils.format(displayName));
        if (lore != null && lore.length > 0) {
            List<String> loreList = Arrays.asList(lore);
            if (lore.length == 1 && lore[0] != null && !lore[0].isEmpty()) {
                loreList = Arrays.asList(lore[0].split("~"));
            }
            loreList = loreList.stream().map(FamiUtils::format).collect(Collectors.toList());
            itemMeta.setLore(loreList);
        }
        item.setItemMeta(itemMeta);
        return item;
    }

    public static boolean isDoubleChest(Block block) {
        if (block.getState() instanceof Chest) {
            Chest chest = (Chest)block.getState();
            InventoryHolder holder = chest.getInventory().getHolder();
            return holder instanceof DoubleChestInventory;
        }
        return false;
    }

    @Nullable
    public static Block getOtherChestBlock(Block chestBlock) {
        Chest chest;
        InventoryHolder holder;
        if (chestBlock.getState() instanceof Chest && (holder = (chest = (Chest)chestBlock.getState()).getInventory().getHolder()) instanceof DoubleChestInventory) {
            DoubleChestInventory doubleChest = (DoubleChestInventory)holder;
            Chest leftChest = (Chest)doubleChest.getLeftSide();
            Chest rightChest = (Chest)doubleChest.getRightSide();
            if (leftChest.getBlock().equals((Object)chestBlock)) {
                return rightChest.getBlock();
            }
            return leftChest.getBlock();
        }
        return null;
    }

    public static boolean isDoubleDoor(Block block) {
        if (!(block.getBlockData() instanceof Door)) {
            return false;
        }
        Door door = (Door)block.getBlockData();
        BlockFace facing = door.getFacing();
        BlockFace hinge = door.getHinge() == Door.Hinge.RIGHT ? facing.getOppositeFace() : facing;
        Block adjacentBlock = block.getRelative(hinge);
        if (adjacentBlock.getType() == block.getType()) {
            Door adjacentDoor = (Door)adjacentBlock.getBlockData();
            return adjacentDoor.getFacing() == facing && adjacentDoor.getHinge() != door.getHinge();
        }
        return false;
    }

    public static ItemStack addGlow(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        meta.addEnchant(Enchantment.ARROW_INFINITE, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack makeSkullItem(OfflinePlayer owner, String displayName, String ... lore) {
        ItemStack skullItem = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)skullItem.getItemMeta();
        skullMeta.setOwningPlayer(owner);
        if (displayName != null && !displayName.isEmpty()) {
            skullMeta.setDisplayName(FamiUtils.format(displayName));
        }
        if (lore != null && lore.length > 0) {
            ArrayList<String> loreList = new ArrayList<String>();
            for (String line : lore) {
                loreList.add(FamiUtils.format(line));
            }
            skullMeta.setLore(loreList);
        }
        skullItem.setItemMeta((ItemMeta)skullMeta);
        return skullItem;
    }
}

