/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist.utils.menus.types;

import java.util.ArrayList;
import java.util.Arrays;
import me.fami6xx.blockywhitelist.BlockyWhitelist;
import me.fami6xx.blockywhitelist.utils.FamiUtils;
import me.fami6xx.blockywhitelist.utils.languages.Lang;
import me.fami6xx.blockywhitelist.utils.menus.PlayerMenu;
import me.fami6xx.blockywhitelist.utils.menus.types.PaginatedMenu;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class EasyPaginatedMenu
extends PaginatedMenu {
    private static final int START_SLOT = 10;
    private static final int SLOTS_PER_ROW = 7;

    public EasyPaginatedMenu(PlayerMenu menu) {
        super(menu);
    }

    public abstract ItemStack getItemFromIndex(int var1);

    public abstract int getCollectionSize();

    public abstract void handlePaginatedMenu(InventoryClickEvent var1);

    @Override
    public void handleMenu(final InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        String name = ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName());
        String closeName = ChatColor.stripColor((String)FamiUtils.format(Lang.closeItemDisplayName));
        String nextName = ChatColor.stripColor((String)FamiUtils.format(Lang.nextPageItemDisplayName));
        String previousName = ChatColor.stripColor((String)FamiUtils.format(Lang.previousPageItemDisplayName));
        if (e.getCurrentItem().getType().equals((Object)BORDER_GLASS.getType())) {
            return;
        }
        if (e.getCurrentItem().getType().equals((Object)Material.BARRIER) && name.equalsIgnoreCase(closeName)) {
            p.closeInventory();
            return;
        }
        if (e.getCurrentItem().getType().equals((Object)Material.STONE_BUTTON)) {
            if (name.equalsIgnoreCase(previousName)) {
                if (this.page == 0) {
                    p.sendMessage(FamiUtils.formatWithPrefix(Lang.errorMenuAlreadyOnFirstPage));
                } else {
                    --this.page;
                    super.open();
                }
                return;
            }
            if (name.equalsIgnoreCase(nextName)) {
                if (this.index + 1 < this.getCollectionSize()) {
                    ++this.page;
                    super.open();
                } else {
                    p.sendMessage(FamiUtils.formatWithPrefix(Lang.errorMenuAlreadyOnLastPage));
                }
                return;
            }
        }
        new BukkitRunnable(){

            public void run() {
                EasyPaginatedMenu.this.handlePaginatedMenu(e);
            }
        }.runTask((Plugin)BlockyWhitelist.getInstance());
    }

    @Override
    public void setMenuItems() {
        this.addMenuBorder();
        this.addAdditionalItems();
        Integer[] borderSlots = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
        ArrayList<Integer> borderSlotsList = new ArrayList<Integer>(Arrays.asList(borderSlots));
        int slot = 10;
        for (int i = 0; i < this.getMaxItemsPerPage(); ++i) {
            this.index = this.getMaxItemsPerPage() * this.page + i;
            while (borderSlotsList.contains(slot)) {
                ++slot;
            }
            if (this.index >= this.getCollectionSize()) {
                this.inventory.setItem(slot, new ItemStack(Material.AIR));
                ++slot;
                continue;
            }
            this.inventory.setItem(slot, this.getItemFromIndex(this.index));
            ++slot;
        }
    }

    public abstract void addAdditionalItems();

    public int getSlotIndex(int slot) {
        int relativeSlot = slot - 10;
        if (relativeSlot < 0) {
            return -1;
        }
        int row = relativeSlot / 7;
        int col = relativeSlot % 7;
        int index = row * 7 + col;
        if (index >= this.getCollectionSize()) {
            return -1;
        }
        return index;
    }
}

