/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist.utils.menus.types;

import me.fami6xx.blockywhitelist.BlockyWhitelist;
import me.fami6xx.blockywhitelist.utils.menus.PlayerMenu;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Menu
implements InventoryHolder {
    protected PlayerMenu playerMenu;
    protected Inventory inventory;
    protected ItemStack FILLER_GLASS = Menu.makeColoredGlass(DyeColor.GRAY);

    public Menu(PlayerMenu menu) {
        this.playerMenu = menu;
    }

    public abstract String getMenuName();

    public abstract int getSlots();

    public abstract void handleMenu(InventoryClickEvent var1);

    public abstract void setMenuItems();

    private void closeAndCreateInv() {
        this.playerMenu.getPlayer().closeInventory(InventoryCloseEvent.Reason.PLUGIN);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.getSlots(), (String)this.getMenuName());
        this.setMenuItems();
        this.playerMenu.getPlayer().openInventory(this.inventory);
    }

    public void open() {
        final Menu menu = this;
        new BukkitRunnable(){

            public void run() {
                if (Menu.this.inventory != null) {
                    if (Menu.this.playerMenu.getPlayer().getOpenInventory() == null) {
                        Menu.this.closeAndCreateInv();
                        return;
                    }
                    if (Menu.this.playerMenu.getPlayer().getOpenInventory().getTopInventory() == null) {
                        Menu.this.closeAndCreateInv();
                        return;
                    }
                    if (Menu.this.playerMenu.getPlayer().getOpenInventory().getTopInventory() != menu.inventory) {
                        Menu.this.closeAndCreateInv();
                        return;
                    }
                    if (!Menu.this.playerMenu.getPlayer().getOpenInventory().getTitle().equals(menu.getMenuName())) {
                        Menu.this.closeAndCreateInv();
                        return;
                    }
                    menu.setMenuItems();
                } else {
                    Menu.this.closeAndCreateInv();
                }
            }
        }.runTaskLater((Plugin)BlockyWhitelist.getInstance(), 1L);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setFillerGlass() {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, this.FILLER_GLASS);
        }
    }

    public static ItemStack makeColoredGlass(DyeColor color) {
        Material coloredGlassPane = Material.matchMaterial((String)(color.name() + "_STAINED_GLASS_PANE"));
        if (coloredGlassPane == null) {
            throw new IllegalArgumentException("Invalid color: " + String.valueOf(color));
        }
        ItemStack glass = new ItemStack(coloredGlassPane, 1);
        ItemMeta meta = glass.getItemMeta();
        meta.setDisplayName(" ");
        glass.setItemMeta(meta);
        return glass;
    }
}

