/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.fami6xx.blockywhitelist.BlockyWhitelistCommand;
import me.fami6xx.blockywhitelist.JSONStore;
import me.fami6xx.blockywhitelist.discord.DiscordCommandListener;
import me.fami6xx.blockywhitelist.utils.FamiUtils;
import me.fami6xx.blockywhitelist.utils.languages.Lang;
import me.fami6xx.blockywhitelist.utils.languages.LocalizationUtil;
import me.fami6xx.blockywhitelist.utils.menus.MenuManager;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.exceptions.InvalidTokenException;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class BlockyWhitelist
extends JavaPlugin
implements Listener {
    private JSONStore jsonStore;
    private JDA jda;
    private Guild guild;
    private static final SecureRandom random = new SecureRandom();
    private boolean loadedMembers = false;
    private MenuManager menuManager;
    private File langFile;

    public void onEnable() {
        boolean firstSetup;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        File file = new File(this.getDataFolder(), "data.json");
        this.jsonStore = JSONStore.load(file);
        if (this.jsonStore == null) {
            this.getLogger().severe("Failed to load data.json");
            this.getLogger().severe("Please delete BlockyWhitelist folder and restart the server");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.langFile = new File(this.getDataFolder(), "languages.json");
        if (!this.langFile.exists()) {
            this.getLogger().info("Creating languages.json");
            try {
                LocalizationUtil.saveStaticTranslationsToFile(Lang.class, this.langFile);
                this.getLogger().info("Translations saved");
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to save translations to " + this.langFile.getPath());
                this.getLogger().severe(e.getMessage());
            }
        } else {
            this.getLogger().info("Loading translations");
            try {
                LocalizationUtil.loadStaticTranslationsFromFile(Lang.class, this.langFile);
                this.getLogger().info("Translations loaded successfully");
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to load translations from " + this.langFile.getPath());
                this.getLogger().severe(e.getMessage());
            }
        }
        this.menuManager = new MenuManager();
        if (!this.menuManager.enable()) {
            this.getLogger().severe("Failed to enable MenuManager! Disabling plugin...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        } else {
            this.getLogger().info("MenuManager enabled!");
        }
        boolean bl = firstSetup = this.jsonStore.botToken.isEmpty() || this.jsonStore.guildId.isEmpty();
        if (firstSetup) {
            this.getLogger().info("First setup detected, please configure the plugin in-game");
            this.getLogger().info("For setup, type /blockywhitelist");
            this.loadedMembers = true;
        } else {
            this.getLogger().info("Bot token and guild ID loaded successfully");
            List<String> errors = this.loadJDA();
            if (!errors.isEmpty()) {
                this.getLogger().severe("Errors encountered while loading JDA:");
                errors.forEach(this.getLogger()::severe);
                return;
            }
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("blockywhitelist").setExecutor((CommandExecutor)new BlockyWhitelistCommand());
    }

    public void onDisable() {
        try {
            this.jsonStore.save();
            try {
                LocalizationUtil.saveStaticTranslationsToFile(Lang.class, this.langFile);
                this.getLogger().info("Translations saved");
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to save translations to " + this.langFile.getPath());
                this.getLogger().severe(e.getMessage());
            }
            if (this.jda != null) {
                this.getLogger().info("Shutting down Discord bot");
                this.jda.shutdown();
                if (!this.jda.awaitShutdown(Duration.ofSeconds(10L))) {
                    this.jda.shutdownNow();
                    this.jda.awaitShutdown();
                }
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to shutdown");
            this.getLogger().severe(e.getMessage());
        }
    }

    @EventHandler
    public void onPreLogin(AsyncPlayerPreLoginEvent event) {
        if (this.jsonStore.botToken.isEmpty() || this.jsonStore.guildId.isEmpty() || this.jda == null || this.guild == null || this.jsonStore.addedRoles.isEmpty() || this.jsonStore.allowedRoles.isEmpty()) {
            return;
        }
        if (!this.loadedMembers) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, this.getKickMessageLoadingMembers());
            return;
        }
        if (this.jsonStore.linkedPlayers.containsKey(event.getUniqueId())) {
            String discordId = this.jsonStore.linkedPlayers.get(event.getUniqueId());
            if (discordId == null) {
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, this.getKickMessageNotLinked(event.getUniqueId()));
                return;
            }
            if (this.guild.getMemberById(discordId) == null) {
                this.getLogger().warning("Discord ID " + discordId + " not found in guild");
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, this.getKickMessageNotLinked(event.getUniqueId()));
                return;
            }
            Member member = this.guild.getMemberById(discordId);
            boolean whitelisted = member.getRoles().stream().anyMatch(role -> this.jsonStore.addedRoles.contains(role.getId()));
            if (!whitelisted) {
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, this.getKickMessageNotWhitelisted());
                return;
            }
            this.getLogger().info(event.getName() + " is whitelisted for @" + member.getEffectiveName() + " (" + member.getId() + ")");
            return;
        }
        if (!this.jsonStore.pendingPlayers.containsValue(event.getUniqueId()) || this.jsonStore.pendingPlayers.containsValue(event.getUniqueId())) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, this.getKickMessageNotLinked(event.getUniqueId()));
            return;
        }
    }

    public List<String> loadJDA() {
        ArrayList<String> errors = new ArrayList<String>();
        this.loadedMembers = false;
        try {
            this.jda = JDABuilder.createDefault((String)this.jsonStore.botToken).enableIntents(GatewayIntent.GUILD_MEMBERS, new GatewayIntent[0]).setMemberCachePolicy(MemberCachePolicy.ALL).build().awaitReady();
            this.jda.setAutoReconnect(true);
            this.guild = this.jda.getGuildById(this.jsonStore.guildId);
            if (this.guild == null) {
                this.getLogger().severe("Failed to find guild with id " + this.jsonStore.guildId);
                throw new IllegalStateException("Failed to connect to Discord server");
            }
            this.jda.getPresence().setPresence(OnlineStatus.DO_NOT_DISTURB, Activity.watching((String)this.guild.getName()), false);
            this.guild.loadMembers().onSuccess(result -> {
                this.getLogger().info("Loaded " + result.size() + " members to cache");
                this.loadedMembers = true;
                this.getLogger().info("Connection of players is now allowed");
            });
            this.getLogger().info("Checking roles...");
            for (String roleId : this.jsonStore.allowedRoles) {
                if (this.guild.getRoleById(roleId) != null) continue;
                this.getLogger().severe("Failed to find whitelist adder role with id " + roleId);
                errors.add("Failed to find whitelist adder role with id " + roleId);
            }
            for (String roleId : this.jsonStore.addedRoles) {
                if (this.guild.getRoleById(roleId) != null) continue;
                this.getLogger().severe("Failed to find whitelisted role with id " + roleId);
                errors.add("Failed to find whitelisted role with id " + roleId);
            }
            if (!this.jsonStore.failedRoleIdOne.isEmpty() && this.guild.getRoleById(this.jsonStore.failedRoleIdOne) == null) {
                this.getLogger().severe("Failed to find failed attempt one role with id " + this.jsonStore.failedRoleIdOne);
                errors.add("Failed to find failed attempt one role with id " + this.jsonStore.failedRoleIdOne);
            }
            if (!this.jsonStore.failedRoleIdTwo.isEmpty() && this.guild.getRoleById(this.jsonStore.failedRoleIdTwo) == null) {
                this.getLogger().severe("Failed to find failed attempt two role with id " + this.jsonStore.failedRoleIdTwo);
                errors.add("Failed to find failed attempt two role with id " + this.jsonStore.failedRoleIdTwo);
            }
            if (!this.jsonStore.failedRoleIdThree.isEmpty() && this.guild.getRoleById(this.jsonStore.failedRoleIdThree) == null) {
                this.getLogger().severe("Failed to find failed attempt three role with id " + this.jsonStore.failedRoleIdThree);
                errors.add("Failed to find failed attempt three role with id " + this.jsonStore.failedRoleIdThree);
            }
            this.getLogger().info("Registering commands...");
            this.guild.upsertCommand("link", Lang.linkDiscordCommandDescription).addOption(OptionType.STRING, "code", Lang.linkDiscordCommandCodeProvided, true).queue();
            this.guild.upsertCommand("whitelist", Lang.whitelistDiscordCommandDescription).addOption(OptionType.USER, "user", Lang.whitelistDiscordCommandUserProvided, true).queue();
            this.guild.upsertCommand("failed", Lang.failedDiscordCommandDescription).addOption(OptionType.INTEGER, "attempt", Lang.failedDiscordCommandAttemptProvided, true).addOption(OptionType.USER, "user", Lang.failedDiscordCommandUserProvided, true).queue();
            this.guild.upsertCommand("username", Lang.usernameDiscordCommandDescription).addOption(OptionType.USER, "user", Lang.usernameDiscordCommandUserProvided, true).queue();
            this.jda.addEventListener(new Object[]{new DiscordCommandListener()});
            this.getLogger().info("Finished loading JDA");
        }
        catch (IllegalArgumentException | IllegalStateException | InterruptedException | InvalidTokenException e) {
            if (e instanceof InvalidTokenException) {
                errors.add("Invalid bot token");
            }
            if (e instanceof IllegalArgumentException) {
                errors.add("Bot token is empty");
            }
            if (e instanceof IllegalStateException) {
                errors.add("Something went wrong: " + e.getMessage());
            }
            errors.add("Failed initializing JDA: " + e.getMessage());
        }
        return errors;
    }

    private String getKickMessageNotWhitelisted() {
        return FamiUtils.format(Lang.kickNotWhitelisted);
    }

    private String getKickMessageNotSetup() {
        return FamiUtils.format(Lang.kickNotSetup);
    }

    private String getKickMessageLoadingMembers() {
        return FamiUtils.format(Lang.kickLoadingMembers);
    }

    private String getKickMessageNotLinked(final UUID uuid) {
        try {
            if (this.jsonStore.pendingPlayers.containsValue(uuid)) {
                String code;
                try {
                    Set<String> codes = this.jsonStore.pendingPlayers.keySet();
                    code = codes.stream().filter(s -> this.jsonStore.pendingPlayers.get(s).equals(uuid)).findFirst().orElse(null);
                    if (code == null) {
                        throw new Exception("No code found");
                    }
                }
                catch (Exception e) {
                    this.getLogger().severe("Failed to get code for player " + String.valueOf(uuid));
                    return FamiUtils.format(Lang.kickNotLinkedError);
                }
                return FamiUtils.format(Lang.kickNotLinkedCode.replace("{code}", code));
            }
            String code = BlockyWhitelist.generateRandomString(6);
            int attempts = 0;
            while (this.jsonStore.pendingPlayers.containsKey(code)) {
                if (attempts >= 10) {
                    this.getLogger().severe("Failed to generate a unique code");
                    return FamiUtils.format(Lang.kickNotLinkedContactAdmin);
                }
                code = BlockyWhitelist.generateRandomString(6);
                ++attempts;
            }
            final String finalCode = code;
            new BukkitRunnable(){

                public void run() {
                    BlockyWhitelist.this.jsonStore.pendingPlayers.put(finalCode, uuid);
                    BlockyWhitelist.this.jsonStore.save();
                }
            }.runTask((Plugin)this);
            return FamiUtils.format(Lang.kickNotLinkedCode.replace("{code}", code));
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to get code for player " + String.valueOf(uuid));
            return FamiUtils.format(Lang.kickNotLinkedError);
        }
    }

    public static String generateRandomString(int length) {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(chars.charAt(random.nextInt(chars.length())));
        }
        return sb.toString();
    }

    public JSONStore getJsonStore() {
        return this.jsonStore;
    }

    public JDA getJDA() {
        return this.jda;
    }

    public Guild getGuild() {
        return this.guild;
    }

    public static BlockyWhitelist getInstance() {
        return (BlockyWhitelist)BlockyWhitelist.getPlugin(BlockyWhitelist.class);
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }
}

