/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist.discord;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.fami6xx.blockywhitelist.BlockyWhitelist;
import me.fami6xx.blockywhitelist.JSONStore;
import me.fami6xx.blockywhitelist.utils.FamiUtils;
import me.fami6xx.blockywhitelist.utils.languages.Lang;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class DiscordCommandListener
extends ListenerAdapter {
    private final Map<String, Long> lastCommandUsage = new HashMap<String, Long>();
    private static final long COMMAND_COOLDOWN_MS = 1500L;

    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        HashMap<String, String> replace;
        boolean hasPermission;
        JSONStore jsonStore;
        BlockyWhitelist plugin;
        long lastUsage;
        String userId = event.getUser().getId();
        long currentTime = System.currentTimeMillis();
        if (this.lastCommandUsage.containsKey(userId) && currentTime - (lastUsage = this.lastCommandUsage.get(userId).longValue()) < 1500L) {
            event.reply("Please wait before using commands again.").setEphemeral(true).queue();
            return;
        }
        this.lastCommandUsage.put(userId, currentTime);
        String command = event.getName();
        if ("whitelist".equalsIgnoreCase(command)) {
            if (event.getMember() == null) {
                event.reply(Lang.errorNotDiscordMember).setEphemeral(true).queue();
                return;
            }
            if (event.getGuild() == null) {
                event.reply(Lang.errorNotGuild).setEphemeral(true).queue();
                return;
            }
            plugin = BlockyWhitelist.getInstance();
            jsonStore = plugin.getJsonStore();
            if (!event.getGuild().getId().equals(jsonStore.guildId)) {
                event.reply(Lang.errorNotGuild).setEphemeral(true).queue();
                return;
            }
            hasPermission = event.getMember().getRoles().stream().anyMatch(role -> jsonStore.allowedRoles.contains(role.getId()));
            if (!hasPermission) {
                event.reply(Lang.errorNoPermission).setEphemeral(true).queue();
                return;
            }
            if (event.getOption("user") == null) {
                event.reply(Lang.errorNoUserProvided).setEphemeral(true).queue();
                return;
            }
            User toWhitelistUser = event.getOption("user").getAsUser();
            List<Role> toAdd = event.getGuild().getRoles().stream().filter(role -> jsonStore.addedRoles.contains(role.getId())).toList();
            if (toAdd.isEmpty()) {
                event.reply(Lang.errorNoRoleSet).setEphemeral(true).queue();
                return;
            }
            List usersWithRoles = event.getGuild().getMembersWithRoles(toAdd);
            if (usersWithRoles.stream().anyMatch(member -> member.getId().equals(toWhitelistUser.getId()))) {
                HashMap<String, String> replace2 = new HashMap<String, String>();
                replace2.put("{player}", toWhitelistUser.getAsMention());
                event.reply(FamiUtils.replaceAndFormat(Lang.errorPlayerAlreadyWhitelisted, replace2)).setEphemeral(true).queue();
                return;
            }
            HashMap<String, String> replace3 = new HashMap<String, String>();
            replace3.put("{user}", toWhitelistUser.getAsMention());
            ((ReplyCallbackAction)event.reply(FamiUtils.replaceAndFormat(Lang.areYouSureToWhitelist, replace3)).addActionRow(new ItemComponent[]{Button.success((String)("confirm-bwl-" + toWhitelistUser.getId()), (String)Lang.areYouSureConfirmButton), Button.danger((String)"cancel-bwl", (String)Lang.areYouSureCancelButton)})).setEphemeral(true).queue();
            plugin.getLogger().info(String.format("User %s (%s) executed %s command for target %s", event.getUser().getName(), event.getUser().getId(), command, toWhitelistUser.getName()));
        }
        if ("link".equalsIgnoreCase(command)) {
            if (event.getMember() == null) {
                event.reply(Lang.errorNotDiscordMember).setEphemeral(true).queue();
                return;
            }
            if (event.getGuild() == null) {
                event.reply(Lang.errorNotGuild).setEphemeral(true).queue();
                return;
            }
            plugin = BlockyWhitelist.getInstance();
            jsonStore = plugin.getJsonStore();
            if (!event.getGuild().getId().equals(jsonStore.guildId)) {
                event.reply(Lang.errorNotGuild).setEphemeral(true).queue();
                return;
            }
            if (event.getOption("code") == null) {
                event.reply(Lang.errorNoCodeProvided).setEphemeral(true).queue();
                return;
            }
            if (jsonStore.linkedPlayers.containsValue(event.getMember().getId())) {
                event.reply(Lang.errorAccountAlreadyLinked).setEphemeral(true).queue();
                return;
            }
            String code = event.getOption("code").getAsString();
            if (!code.matches("^[A-Za-z0-9]{6}$")) {
                event.reply("Invalid code format.").setEphemeral(true).queue();
                return;
            }
            if (!jsonStore.pendingPlayers.containsKey(code)) {
                event.reply(Lang.errorInvalidCode).setEphemeral(true).queue();
                return;
            }
            UUID toLinkUser = jsonStore.pendingPlayers.get(code);
            jsonStore.pendingPlayers.remove(code);
            jsonStore.linkedPlayers.put(toLinkUser, event.getMember().getId());
            jsonStore.save();
            event.reply(Lang.successAccountLinked).setEphemeral(true).queue();
        }
        if ("failed".equalsIgnoreCase(command)) {
            Object roleId;
            if (event.getMember() == null) {
                event.reply(Lang.errorNotDiscordMember).setEphemeral(true).queue();
                return;
            }
            if (event.getGuild() == null) {
                event.reply(Lang.errorNotGuild).setEphemeral(true).queue();
                return;
            }
            plugin = BlockyWhitelist.getInstance();
            jsonStore = plugin.getJsonStore();
            if (!event.getGuild().getId().equals(jsonStore.guildId)) {
                event.reply(Lang.errorNotGuild).setEphemeral(true).queue();
                return;
            }
            hasPermission = event.getMember().getRoles().stream().anyMatch(role -> jsonStore.allowedRoles.contains(role.getId()));
            if (!hasPermission) {
                event.reply(Lang.errorNoPermission).setEphemeral(true).queue();
                return;
            }
            if (event.getOption("attempt") == null) {
                event.reply(Lang.errorNoAttemptProvided).setEphemeral(true).queue();
                return;
            }
            if (event.getOption("user") == null) {
                event.reply(Lang.errorNoUserProvided).setEphemeral(true).queue();
                return;
            }
            int attempt = event.getOption("attempt").getAsInt();
            User toFailUser = event.getOption("user").getAsUser();
            if (attempt < 1 || attempt > 3) {
                event.reply(Lang.errorInvalidAttempt).setEphemeral(true).queue();
                return;
            }
            switch (attempt) {
                case 1: {
                    Object object = jsonStore.failedRoleIdOne;
                    break;
                }
                case 2: {
                    Object object = jsonStore.failedRoleIdTwo;
                    break;
                }
                case 3: {
                    Object object = jsonStore.failedRoleIdThree;
                    break;
                }
                default: {
                    Object object = roleId = null;
                }
            }
            if (roleId == null || ((String)roleId).isEmpty()) {
                event.reply(Lang.errorNoRoleForAttempt).setEphemeral(true).queue();
                return;
            }
            Role role2 = event.getGuild().getRoleById((String)roleId);
            if (role2 == null) {
                event.reply(Lang.errorRoleNotFound).setEphemeral(true).queue();
                return;
            }
            if (event.getGuild().getMembersWithRoles(new Role[]{role2}).stream().anyMatch(member -> member.getId().equals(toFailUser.getId()))) {
                HashMap<String, String> replace4 = new HashMap<String, String>();
                replace4.put("{player}", toFailUser.getAsMention());
                event.reply(FamiUtils.replaceAndFormat(Lang.errorPlayerAlreadyHasRole, replace4)).setEphemeral(true).queue();
                return;
            }
            event.getGuild().addRoleToMember((UserSnowflake)toFailUser, role2).queue();
            replace = new HashMap();
            replace.put("{player}", toFailUser.getAsMention());
            replace.put("{attempt}", String.valueOf(attempt));
            event.reply(FamiUtils.replaceAndFormat(Lang.successRoleGivenForAttempt, replace)).queue();
            plugin.getLogger().info(String.format("User %s (%s) executed %s command for target %s", event.getUser().getName(), event.getUser().getId(), command, toFailUser.getName()));
        }
        if ("username".equalsIgnoreCase(command)) {
            if (event.getMember() == null) {
                event.reply(Lang.errorNotDiscordMember).setEphemeral(true).queue();
                return;
            }
            if (event.getGuild() == null) {
                event.reply(Lang.errorNotGuild).setEphemeral(true).queue();
                return;
            }
            plugin = BlockyWhitelist.getInstance();
            jsonStore = plugin.getJsonStore();
            hasPermission = event.getMember().getRoles().stream().anyMatch(role -> jsonStore.allowedRoles.contains(role.getId()));
            if (!hasPermission) {
                event.reply(Lang.errorNoPermission).setEphemeral(true).queue();
                return;
            }
            if (!event.getGuild().getId().equals(jsonStore.guildId)) {
                event.reply(Lang.errorNotGuild).setEphemeral(true).queue();
                return;
            }
            if (event.getOption("user") == null) {
                event.reply(Lang.errorNoUserProvided).setEphemeral(true).queue();
                return;
            }
            String discordId = event.getOption("user").getAsUser().getId();
            UUID minecraftUUID = null;
            for (Map.Entry<UUID, String> entry : jsonStore.linkedPlayers.entrySet()) {
                if (!entry.getValue().equals(discordId)) continue;
                minecraftUUID = entry.getKey();
                break;
            }
            if (minecraftUUID == null) {
                event.reply(Lang.errorNoAccountLinked).setEphemeral(true).queue();
                return;
            }
            OfflinePlayer player = Bukkit.getOfflinePlayer(minecraftUUID);
            String username = player.getName();
            if (username == null) {
                username = Lang.unknown;
            }
            replace = new HashMap<String, String>();
            replace.put("{player}", event.getMember().getAsMention());
            replace.put("{username}", username);
            event.reply(FamiUtils.replaceAndFormat(Lang.successUsernameRetrieved, replace)).setEphemeral(true).queue();
            plugin.getLogger().info(String.format("User %s (%s) executed %s command for target %s", event.getUser().getName(), event.getUser().getId(), command, username));
        }
    }

    public void onButtonInteraction(ButtonInteractionEvent event) {
        if (event.getComponentId().contains("confirm-bwl-")) {
            String userId = event.getComponentId().substring(12);
            BlockyWhitelist plugin = BlockyWhitelist.getInstance();
            JSONStore jsonStore = plugin.getJsonStore();
            Member toWhitelistUser = event.getGuild().getMemberById(userId);
            if (toWhitelistUser == null) {
                event.reply("User not found.").setEphemeral(true).queue();
                return;
            }
            List<Role> toAdd = event.getGuild().getRoles().stream().filter(role -> jsonStore.addedRoles.contains(role.getId())).toList();
            if (toAdd.isEmpty()) {
                event.reply(Lang.errorNoRoleSet).setEphemeral(true).queue();
                return;
            }
            List usersWithRoles = event.getGuild().getMembersWithRoles(toAdd);
            if (usersWithRoles.stream().anyMatch(member -> member.getId().equals(toWhitelistUser.getId()))) {
                HashMap<String, String> replace = new HashMap<String, String>();
                replace.put("{player}", toWhitelistUser.getAsMention());
                event.reply(FamiUtils.replaceAndFormat(Lang.errorPlayerAlreadyWhitelisted, replace)).setEphemeral(true).queue();
                return;
            }
            for (Role role2 : toAdd) {
                event.getGuild().addRoleToMember((UserSnowflake)toWhitelistUser, role2).queue();
            }
            HashMap replace = new HashMap();
            replace.put("{player}", toWhitelistUser.getAsMention());
            event.reply(FamiUtils.replaceAndFormat(Lang.successPlayerWhitelisted, replace)).setEphemeral(true).queue();
            plugin.getLogger().info(String.format("User %s (%s) confirmed whitelist for target %s", event.getUser().getName(), event.getUser().getId(), toWhitelistUser.getUser().getName()));
        }
        if (event.getComponentId().contentEquals("cancel-bwl")) {
            event.reply(Lang.cancelledWhitelisting).setEphemeral(true).queue();
        }
    }
}

