/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist.menus;

import java.util.List;
import me.fami6xx.blockywhitelist.BlockyWhitelist;
import me.fami6xx.blockywhitelist.menus.FailedAttemptsMenu;
import me.fami6xx.blockywhitelist.menus.LinkedUsersMenu;
import me.fami6xx.blockywhitelist.menus.PendingUsersMenu;
import me.fami6xx.blockywhitelist.menus.WhitelistRolesMenu;
import me.fami6xx.blockywhitelist.menus.WhitelistersMenu;
import me.fami6xx.blockywhitelist.utils.FamiUtils;
import me.fami6xx.blockywhitelist.utils.menus.PlayerMenu;
import me.fami6xx.blockywhitelist.utils.menus.types.Menu;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.util.Consumer;

public class ChooseNextStepMenu
extends Menu {
    private final BlockyWhitelist blockyWhitelist = BlockyWhitelist.getInstance();

    public ChooseNextStepMenu(PlayerMenu menu) {
        super(menu);
    }

    @Override
    public String getMenuName() {
        return FamiUtils.format("&b&lBW &c&lChoose");
    }

    @Override
    public int getSlots() {
        return 18;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        switch (e.getCurrentItem().getType()) {
            case OAK_SIGN: {
                if (this.playerMenu.getPendingAction() != null) {
                    player.sendMessage(FamiUtils.format("&c&lERROR! &7You have already something to write!"));
                    player.closeInventory();
                    return;
                }
                player.sendMessage(FamiUtils.format("&b&lBW &7Please write in chat the bot token."));
                player.closeInventory();
                this.playerMenu.setPendingAction((Consumer<String>)((Consumer)s -> {
                    this.blockyWhitelist.getJsonStore().botToken = s;
                    this.blockyWhitelist.getJsonStore().save();
                    player.sendMessage(FamiUtils.format("&b&lBW &7Bot token set to &a" + s));
                    if (!this.blockyWhitelist.getJsonStore().guildId.isEmpty()) {
                        List<String> errors = this.blockyWhitelist.loadJDA();
                        if (!errors.isEmpty()) {
                            player.sendMessage(FamiUtils.format("&b&lBW &cErrors while loading bot:"));
                            for (String error : errors) {
                                player.sendMessage(FamiUtils.format("&c- " + error));
                            }
                            return;
                        }
                        player.sendMessage(FamiUtils.format("&b&lBW &aBot loaded successfully!"));
                        this.blockyWhitelist.getLogger().info("Bot loaded successfully!");
                    }
                    this.open();
                }));
                break;
            }
            case COMPASS: {
                if (this.playerMenu.getPendingAction() != null) {
                    player.sendMessage(FamiUtils.format("&c&lERROR! &7You have already something to write!"));
                    player.closeInventory();
                    return;
                }
                player.sendMessage(FamiUtils.format("&b&lBW &7Please write in chat the guild id."));
                player.closeInventory();
                this.playerMenu.setPendingAction((Consumer<String>)((Consumer)s -> {
                    this.blockyWhitelist.getJsonStore().guildId = s;
                    this.blockyWhitelist.getJsonStore().save();
                    player.sendMessage(FamiUtils.format("&b&lBW &7Guild id set to &a" + s));
                    if (!this.blockyWhitelist.getJsonStore().botToken.isEmpty()) {
                        List<String> errors = this.blockyWhitelist.loadJDA();
                        if (!errors.isEmpty()) {
                            player.sendMessage(FamiUtils.format("&b&lBW &cErrors while loading bot:"));
                            for (String error : errors) {
                                player.sendMessage(FamiUtils.format("&c- " + error));
                            }
                            return;
                        }
                        player.sendMessage(FamiUtils.format("&b&lBW &aBot loaded successfully!"));
                        this.blockyWhitelist.getLogger().info("Bot loaded successfully!");
                    }
                    this.open();
                }));
                break;
            }
            case PAPER: {
                if (this.blockyWhitelist.getJDA() == null) {
                    player.sendMessage(FamiUtils.format("&b&lBW &cPlease set the bot token and guild id first."));
                    player.closeInventory();
                    return;
                }
                WhitelistersMenu whitelistersMenu = new WhitelistersMenu(this.playerMenu);
                whitelistersMenu.open();
                break;
            }
            case EMERALD: {
                if (this.blockyWhitelist.getJDA() == null) {
                    player.sendMessage(FamiUtils.format("&b&lBW &cPlease set the bot token and guild id first."));
                    player.closeInventory();
                    return;
                }
                WhitelistRolesMenu whitelistRolesMenu = new WhitelistRolesMenu(this.playerMenu);
                whitelistRolesMenu.open();
                break;
            }
            case REDSTONE: {
                if (this.blockyWhitelist.getJDA() == null) {
                    player.sendMessage(FamiUtils.format("&b&lBW &cPlease set the bot token and guild id first."));
                    player.closeInventory();
                    return;
                }
                FailedAttemptsMenu failedAttemptsMenu = new FailedAttemptsMenu(this.playerMenu);
                failedAttemptsMenu.open();
                break;
            }
            case EMERALD_BLOCK: {
                if (this.blockyWhitelist.getJDA() == null) {
                    player.sendMessage(FamiUtils.format("&b&lBW &cPlease set the bot token and guild id first."));
                    player.closeInventory();
                    return;
                }
                LinkedUsersMenu linkedUsersMenu = new LinkedUsersMenu(this.playerMenu);
                linkedUsersMenu.open();
                break;
            }
            case ARROW: {
                if (this.blockyWhitelist.getJDA() == null) {
                    player.sendMessage(FamiUtils.format("&b&lBW &cPlease set the bot token and guild id first."));
                    player.closeInventory();
                    return;
                }
                PendingUsersMenu pendingUsersMenu = new PendingUsersMenu(this.playerMenu);
                pendingUsersMenu.open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        if (this.blockyWhitelist.getJsonStore().botToken.isEmpty()) {
            this.inventory.setItem(1, FamiUtils.makeItem(Material.OAK_SIGN, "&c&lBot Token", "&7Click to set the bot token."));
        } else {
            this.inventory.setItem(1, FamiUtils.makeItem(Material.OAK_SIGN, "&a&lBot Token", "&7Bot token is set.", "&7Click to change."));
        }
        if (this.blockyWhitelist.getJsonStore().guildId.isEmpty()) {
            this.inventory.setItem(3, FamiUtils.makeItem(Material.COMPASS, "&c&lGuild Id", "&7Click to set the guild id."));
        } else {
            this.inventory.setItem(3, FamiUtils.makeItem(Material.COMPASS, "&a&lGuild Id", "&7Guild id is set.", "&7Click to change."));
        }
        this.inventory.setItem(5, FamiUtils.makeItem(Material.PAPER, "&a&lWhitelist Adders", "&7Click to manage which roles can add whitelist"));
        this.inventory.setItem(7, FamiUtils.makeItem(Material.EMERALD, "&a&lWhitelist roles", "&7Click to manage which roles are whitelisted"));
        this.inventory.setItem(13, FamiUtils.makeItem(Material.REDSTONE, "&a&lFailed Attempts", "&7Click to see failed attempts roles"));
        this.inventory.setItem(15, FamiUtils.makeItem(Material.EMERALD_BLOCK, "&b&lLinked users", "&7Click to see linked users"));
        this.inventory.setItem(11, FamiUtils.makeItem(Material.ARROW, "&c&lPending users", "&7Click to see pending users who have not linked"));
        this.setFillerGlass();
    }
}

