/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist.menus;

import me.fami6xx.blockywhitelist.BlockyWhitelist;
import me.fami6xx.blockywhitelist.JSONStore;
import me.fami6xx.blockywhitelist.menus.ChooseRoleMenu;
import me.fami6xx.blockywhitelist.utils.FamiUtils;
import me.fami6xx.blockywhitelist.utils.menus.PlayerMenu;
import me.fami6xx.blockywhitelist.utils.menus.types.Menu;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Role;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;

public class FailedAttemptsMenu
extends Menu {
    JSONStore store = BlockyWhitelist.getInstance().getJsonStore();
    Guild guild = BlockyWhitelist.getInstance().getGuild();

    public FailedAttemptsMenu(PlayerMenu menu) {
        super(menu);
    }

    @Override
    public String getMenuName() {
        return FamiUtils.format("&b&lBW &cFailed Attempts");
    }

    @Override
    public int getSlots() {
        return 9;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        switch (e.getCurrentItem().getType()) {
            case OAK_LOG: {
                new ChooseRoleMenu(this.playerMenu){

                    @Override
                    public void handleRoleSelection(Role role) {
                        FailedAttemptsMenu.this.store.failedRoleIdOne = role.getId();
                        FailedAttemptsMenu.this.store.save();
                        FailedAttemptsMenu.this.open();
                    }

                    @Override
                    public boolean isAlreadySelected(Role role) {
                        return role.getId().equals(FailedAttemptsMenu.this.store.failedRoleIdOne);
                    }
                }.open();
                break;
            }
            case STONE: {
                new ChooseRoleMenu(this.playerMenu){

                    @Override
                    public void handleRoleSelection(Role role) {
                        FailedAttemptsMenu.this.store.failedRoleIdTwo = role.getId();
                        FailedAttemptsMenu.this.store.save();
                        FailedAttemptsMenu.this.open();
                    }

                    @Override
                    public boolean isAlreadySelected(Role role) {
                        return role.getId().equals(FailedAttemptsMenu.this.store.failedRoleIdTwo);
                    }
                }.open();
                break;
            }
            case DIAMOND: {
                new ChooseRoleMenu(this.playerMenu){

                    @Override
                    public void handleRoleSelection(Role role) {
                        FailedAttemptsMenu.this.store.failedRoleIdThree = role.getId();
                        FailedAttemptsMenu.this.store.save();
                        FailedAttemptsMenu.this.open();
                    }

                    @Override
                    public boolean isAlreadySelected(Role role) {
                        return role.getId().equals(FailedAttemptsMenu.this.store.failedRoleIdThree);
                    }
                }.open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        String name;
        if (this.store.failedRoleIdOne.isEmpty()) {
            this.inventory.setItem(2, FamiUtils.makeItem(Material.OAK_LOG, "&c&lAttempt 1", "&7No role set"));
        } else {
            name = this.guild.getRoleById(this.store.failedRoleIdOne) == null ? "Role not found" : this.guild.getRoleById(this.store.failedRoleIdOne).getName();
            this.inventory.setItem(2, FamiUtils.makeItem(Material.OAK_LOG, "&c&lAttempt 1", "&7Role: &c" + name, "&7Click to change"));
        }
        if (this.store.failedRoleIdTwo.isEmpty()) {
            this.inventory.setItem(4, FamiUtils.makeItem(Material.STONE, "&c&lAttempt 2", "&7No role set"));
        } else {
            name = this.guild.getRoleById(this.store.failedRoleIdTwo) == null ? "Role not found" : this.guild.getRoleById(this.store.failedRoleIdTwo).getName();
            this.inventory.setItem(4, FamiUtils.makeItem(Material.STONE, "&c&lAttempt 2", "&7Role: &c" + name, "&7Click to change"));
        }
        if (this.store.failedRoleIdThree.isEmpty()) {
            this.inventory.setItem(6, FamiUtils.makeItem(Material.DIAMOND, "&c&lAttempt 3", "&7No role set"));
        } else {
            name = this.guild.getRoleById(this.store.failedRoleIdThree) == null ? "Role not found" : this.guild.getRoleById(this.store.failedRoleIdThree).getName();
            this.inventory.setItem(6, FamiUtils.makeItem(Material.DIAMOND, "&c&lAttempt 3", "&7Role: &c" + name, "&7Click to change"));
        }
        this.setFillerGlass();
    }
}

