/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist.menus;

import me.fami6xx.blockywhitelist.BlockyWhitelist;
import me.fami6xx.blockywhitelist.menus.ChooseRoleMenu;
import me.fami6xx.blockywhitelist.utils.FamiUtils;
import me.fami6xx.blockywhitelist.utils.menus.PlayerMenu;
import me.fami6xx.blockywhitelist.utils.menus.types.EasyPaginatedMenu;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Role;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class WhitelistRolesMenu
extends EasyPaginatedMenu {
    private final BlockyWhitelist blockyWhitelist = BlockyWhitelist.getInstance();
    private final NamespacedKey blockyWhitelistKey = new NamespacedKey((Plugin)this.blockyWhitelist, "whitelist");
    private final Guild guild = this.blockyWhitelist.getGuild();

    public WhitelistRolesMenu(PlayerMenu menu) {
        super(menu);
    }

    @Override
    public ItemStack getItemFromIndex(int index) {
        Role role = this.guild.getRoleById(this.blockyWhitelist.getJsonStore().addedRoles.get(index));
        if (role == null) {
            ItemStack barrier = FamiUtils.makeItem(Material.BARRIER, "&c&lERROR! &7Role not found!", "&7Role ID: &c" + this.blockyWhitelist.getJsonStore().addedRoles.get(index), "&7Click to remove");
            ItemMeta meta = barrier.getItemMeta();
            if (meta == null) {
                return null;
            }
            NamespacedKey key = new NamespacedKey((Plugin)this.blockyWhitelist, "whitelist");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)this.blockyWhitelist.getJsonStore().addedRoles.get(index));
            barrier.setItemMeta(meta);
            return barrier;
        }
        ItemStack item = FamiUtils.makeItem(Material.EMERALD, FamiUtils.format("&b" + role.getName()), "&7Click to remove");
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        meta.getPersistentDataContainer().set(this.blockyWhitelistKey, PersistentDataType.STRING, (Object)role.getId());
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public int getCollectionSize() {
        return this.blockyWhitelist.getJsonStore().addedRoles.size();
    }

    @Override
    public void handlePaginatedMenu(InventoryClickEvent e) {
        if (e.getCurrentItem() == null) {
            return;
        }
        if (e.getCurrentItem().getType() == Material.EMERALD_BLOCK) {
            new ChooseRoleMenu(this.playerMenu){

                @Override
                public void handleRoleSelection(Role role) {
                    WhitelistRolesMenu.this.blockyWhitelist.getJsonStore().addedRoles.add(role.getId());
                    WhitelistRolesMenu.this.blockyWhitelist.getJsonStore().save();
                    WhitelistRolesMenu.this.open();
                }

                @Override
                public boolean isAlreadySelected(Role role) {
                    return WhitelistRolesMenu.this.blockyWhitelist.getJsonStore().addedRoles.contains(role.getId());
                }
            }.open();
            return;
        }
        ItemMeta meta = e.getCurrentItem().getItemMeta();
        if (meta == null) {
            return;
        }
        String roleId = (String)meta.getPersistentDataContainer().get(this.blockyWhitelistKey, PersistentDataType.STRING);
        if (roleId == null) {
            return;
        }
        this.blockyWhitelist.getJsonStore().addedRoles.remove(roleId);
        this.blockyWhitelist.getJsonStore().save();
        this.open();
    }

    @Override
    public void addAdditionalItems() {
        this.inventory.setItem(45, FamiUtils.makeItem(Material.EMERALD_BLOCK, "&aAdd Role", "&7Click to add a new role"));
    }

    @Override
    public String getMenuName() {
        return FamiUtils.format("&b&lBW &cWhitelist Roles");
    }
}

