/*
 * Decompiled with CFR 0.152.
 */
package me.fami6xx.blockywhitelist.utils.languages;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class LocalizationUtil {
    public static Map<String, String> extractStaticTranslations(Class<?> clazz) {
        HashMap<String, String> translations = new HashMap<String, String>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getType().equals(String.class) || !Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                String value = (String)field.get(null);
                translations.put(field.getName(), value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return translations;
    }

    public static void applyStaticTranslations(Class<?> clazz, Map<String, String> translations) {
        for (Field field : clazz.getDeclaredFields()) {
            String newValue;
            if (!field.getType().equals(String.class) || !Modifier.isStatic(field.getModifiers()) || (newValue = translations.get(field.getName())) == null) continue;
            field.setAccessible(true);
            try {
                field.set(null, newValue);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveStaticTranslationsToFile(Class<?> clazz, File file) throws IOException {
        Map<String, String> translations = LocalizationUtil.extractStaticTranslations(clazz);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson(translations, (Appendable)writer);
        }
    }

    public static void loadStaticTranslationsFromFile(Class<?> clazz, File file) throws IOException {
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(file);){
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map translations = (Map)gson.fromJson((Reader)reader, type);
            LocalizationUtil.applyStaticTranslations(clazz, translations);
        }
    }
}

