//Made by FSang18
(function () {
    let AABB = Java.loadClass('net.minecraft.world.phys.AABB');
    let LivingEntity = Java.loadClass('net.minecraft.world.entity.LivingEntity');
    let Player = Java.loadClass('net.minecraft.world.entity.player.Player');

    StartupEvents.registry('palladium:condition_serializer', (event) => {
        event.create('finalcut:nearby_entity_condition')
            .addProperty('radius', 'float', 8.0, 'Search radius in blocks')
            .addProperty('entity_type', 'string', 'any', 'any, living, player, non_player_living')
            .addProperty('min_count', 'integer', 1, 'Minimum number required to enable')
            .test((entity, props) => {
                const radius = Math.max(0, props.get('radius'));
                if (radius === 0) return false;

                const type = String(props.get('entity_type') || 'any').toLowerCase();
                let minCount = props.get('min_count');
                if (minCount < 1) minCount = 1;

                const x = entity.getX();
                const y = entity.getY();
                const z = entity.getZ();
                const r = radius;
                const box = new AABB(x - r, y - r, z - r, x + r, y + r, z + r);
                const level = entity.level || entity.getLevel();

                let list;
                switch (type) {
                    case 'player':
                        list = level.getEntitiesOfClass(Player, box, e =>
                            e && !e.isRemoved() && e !== entity && e.distanceToSqr(entity) <= r * r
                        );
                        break;
                    case 'living':
                        list = level.getEntitiesOfClass(LivingEntity, box, e =>
                            e && !e.isRemoved() && e !== entity && e.distanceToSqr(entity) <= r * r
                        );
                        break;
                    case 'non_player_living':
                        list = level.getEntitiesOfClass(LivingEntity, box, e =>
                            e && !e.isRemoved() && !(e instanceof Player) &&
                            e !== entity && e.distanceToSqr(entity) <= r * r
                        );
                        break;
                    default:
                        list = level.getEntities(entity, box, e =>
                            e && !e.isRemoved() && e.distanceToSqr(entity) <= r * r
                        );
                        break;
                }

                return list && list.size() >= minCount;
            });
    });
})();