StartupEvents.registry('palladium:abilities', (event) => {
    event.create('finalcut:reduce_fall')
        .icon(palladium.createItemIcon('minecraft:feather'))
        .documentationDescription('divide fall damage amount')
        .addProperty('division_amount', 'float', 2.5, 'self explanatory')
        .tick((entity, entry, holder, enabled) => {
            if (enabled && entity.isPlayer()) {
                let amount = entry.getPropertyByName('division_amount');
                let distance = entity.fallDistance / amount;
                entity.fallDistance = distance;
            }
        });
});